% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyapp.R
\name{fix_date_app}
\alias{fix_date_app}
\title{Shiny application standardizing date data in csv or excel files}
\usage{
fix_date_app(theme = "datefixR")
}
\arguments{
\item{theme}{Color theme for shiny app. Either \code{"datefixR"}
(\code{datefixR} colors) or \code{"none"}(default shiny app styling).}
}
\value{
A shiny app.
}
\description{
A shiny application which allows users to standardize dates
using a graphical user interface (GUI). Most features of \code{datefixR}
are supported including imputing missing date data. Data can be provided as
CSV (comma-separated value) or XLSX (Excel) files. Processed datasets can
be downloaded as CSV files. Please note, the dependencies for this app
(\code{DT}, \code{htmltools}, \code{readxl}, and \code{shiny}) are not
installed alongside \code{datefixR}. This allows \code{datefixR} to be
installed on secure systems where these packages may not be allowed. If one
of these dependencies is not installed on the system when this function is
called, then the user will be given the option of installing them.
}
\examples{
\dontrun{
fix_date_app()
}
}
\seealso{
The \code{\link[shiny]{shiny}} package.
}
