% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datorama_query.R
\name{datorama_query}
\alias{datorama_query}
\title{A query constructor for the Datorama API}
\usage{
datorama_query(token = NULL, brandId = NULL, dateRange = c("CUSTOM",
  "CUSTOM_ON_GOING", "YESTERDAY", "WEEK_TO_DATE", "BI_WEEK_TO_DATE",
  "MONTH_TO_DATE", "QUARTER_TO_DATE", "YEAR_TO_DATE", "WEEK_TO_DATE_CUSTOM",
  "BI_WEEK_TO_DATE_CUSTOM", "MONTH_TO_DATE_CUSTOM", "QUARTER_TO_DATE_CUSTOM",
  "YEAR_TO_DATE_CUSTOM", "PREV_WEEK", "PREV_BI_WEEK", "PREV_MONTH",
  "PREV_QUARTER", "PREV_YEAR", "PREV_WEEK_CUSTOM", "PREV_BI_WEEK_CUSTOM",
  "PREV_MONTH_CUSTOM", "PREV_QUARTER_CUSTOM", "PREV_YEAR_CUSTOM", "LAST_WEEK",
  "LAST_BI_WEEK", "LAST_MONTH", "LAST_3_MONTHS", "THIS_WEEK",     
  "THIS_BI_WEEK", "THIS_MONTH", "THIS_QUARTER", "THIS_YEAR", "THIS_WEEK_CUSTOM",
  "THIS_BI_WEEK_CUSTOM", "THIS_MONTH_CUSTOM", "THIS_QUARTER_CUSTOM",
  "THIS_YEAR_CUSTOM"), startDate = NULL, endDate = NULL,
  measurements = NULL, dimensions = NULL, groupDimensionFilters = NULL,
  stringDimensionFilters = NULL, stringDimensionFiltersOperator = NULL,
  numberMeasurementFilter = NULL, sortBy = NULL, sortOrder = NULL,
  topResults = NULL, groupOthers = NULL, topPerDimension = NULL)
}
\arguments{
\item{token}{A string containing your token for authentication. Get in \code{datorama_auth}}

\item{brandId}{A string containing the Brand ID}

\item{dateRange}{A string containing date range for query}

\item{startDate}{A string -> format YYYY-MM-DD}

\item{endDate}{A string -> format YYYY-MM-DD}

\item{measurements}{A list of lists including attributes to include -> list(list(name = "Investment"))}

\item{dimensions}{A list of dimensions to be included -> list("Day", "Site Name")}

\item{groupDimensionFilters}{A list of lists including dimension, operator -> "IN", "NOT IN", and vals for filtering}

\item{stringDimensionFilters}{A list of lists including dimension, operator -> "EQUALS", "NOT_EQUALS", "NOT_EQUALS_CASE_SENSITIVE", "CONTAINS", "NOT_CONTAINS", "STARTS_WITH", "ENDS_WITH", "IS_EMPTY", "IS_NOT_EMPTY", and val for filtering}

\item{stringDimensionFiltersOperator}{A string for string dimension filtering -> "AND", "OR"}

\item{numberMeasurementFilter}{A list of lists including filedName (measurement name), operator -> "EQUALS", "NOT_EQUALS", "GREATER", "GREATER_EQUALS", "LESS", "LESS_EQUALS", "IS_NULL", "IS_NOT_NULL", "IS_NAN", "IS_NOT_NAN" and val for filtering}

\item{sortBy}{A string including name of dimension/measurement to sort by}

\item{sortOrder}{A string containing the order of the sort -> "ASC", "DESC"}

\item{topResults}{A string containing the number of results to return}

\item{groupOthers}{Boolean determining whether to group all results not in topResults}

\item{topPerDimension}{Boolean determining whether to return topResults per dimension}
}
\value{
A tibble with the query's response
}
\description{
A query constructor for the Datorama API
}
\examples{
\dontrun{
datorama_query(token = "aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee",
               brandId = "271",
               dateRange = "CUSTOM",
               startDate = "2017-11-01",
               endDate = "2017-11-20",
               measurements = list(list(name = "Clicks"),
                              list(name = "Impressions")),
               dimensions = list("Day", "Site Name")
)
}
}
