% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datplot_utility.R
\name{get.weights}
\alias{get.weights}
\title{Calculate the weights for each dated object}
\usage{
get.weights(DAT_min, DAT_max, verbose = FALSE)
}
\arguments{
\item{DAT_min}{a numeric vector containing the minimum date of each object}

\item{DAT_max}{a numeric vector containing the maximum date of each object}

\item{verbose}{TRUE / FALSE: Should the function issue additional
messages pointing to possible inconsistencies and notify of methods?}
}
\value{
a vector of 'weight'-values for the datsteps-data.frame, that is a
quantification of how well the object is dated (lesser value means object
is dated to larger timespans, i.e. with less confidence)
}
\description{
Calculates the weights from two vectors of minimum and maximum
dating for each object. Returns a dataframe with the weight in the first
column and FALSE in the second if two rows have the same value in both
min and max dating. See [publication](https://doi.org/10.1017/aap.2021.8)
for information about how this is calculated.
}
\seealso{
[datsteps()], [get.probability()]
}
