% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbWebForms.R
\name{createHTMLFormFunction}
\alias{createHTMLFormFunction}
\title{Based on the columns in a table, produces a R function with parameters for each column that produces a HTML form when called.}
\usage{
createHTMLFormFunction(
  filepath,
  function_name,
  form_method = "POST",
  add_csrf_param = TRUE,
  form_class = NULL,
  input_class = NULL,
  submit_class = NULL,
  submit_label = "Save",
  required_span_class = NULL,
  required_span_label = NULL,
  x,
  id_col,
  type_col,
  labels = c(),
  select = c(),
  exclude = c(),
  optional = c(),
  custom_input_types = list()
)
}
\arguments{
\item{filepath}{A string, the file path including the name and file type extension where the output will be written.}

\item{function_name}{A string, the name of the function to be written to the file path.}

\item{form_method}{A string, the method attribute for the HTML form tag, likely "GET" or "POST".}

\item{add_csrf_param}{TRUE/FALSE, if TRUE, adds a parameter for passing a value to a hidden input with a name of "crsf_token".}

\item{form_class}{A string, the class attribute for the HTML form tag.}

\item{input_class}{A string, the class attribute for the div tag wrapping the HTML inputs.}

\item{submit_class}{A string, the class attribute for the HTML button tag used to submit the form.}

\item{submit_label}{A string, the label attribute for the HTML button tag used to submit the form.}

\item{required_span_class}{A string, the class attribute for the HTML span tag optionally added to required fields.}

\item{required_span_label}{A string, the message for the HTML span tag optionally added to required fields.}

\item{x}{A data.table, should have a column of input ids (used for input names as well), and a column of HTML input types.}

\item{id_col}{A string, the column of x containing the HTML input ids.}

\item{type_col}{A string, the column of x containing the HTML input types (usually created by calling dbTypeToHTMLInputType()) .}

\item{labels}{A named character vector, names are the ids of the inputs and values are the labels to use. If a column is not specified here,
the default label is the result of namesToLabels() called for each input id.}

\item{select}{A character vector, ids included here will become select tags rather than input tags and a function parameter will be added to pass options.}

\item{exclude}{A character vector, ids included here will not be included as parameters for the resultant function.}

\item{optional}{A character vector, ids included here will not be marked as required inputs in the relevant HTML tags.}

\item{custom_input_types}{A named list of character vectors, names are the column ids, character vectors must have an entry named type with a value for
the HTML input type to be used and additional attributes can be included as subsequent named values in the character vector.}
}
\value{
A character vector, the HTML input type and attributes likely associated with the SQL data type.
}
\description{
Based on the columns in a table, produces a R function with parameters for each column that produces a HTML form when called.
}
\examples{
createHTMLFormFunction(
filepath = paste0(tempdir(), "/", "testHTMLFormFunction.R"),
function_name = "example_function",
form_method = "POST",
add_csrf_param = TRUE,
form_class ="pure-form pure-form-aligned",
input_class = "pure-control-group",
submit_class = "pure-button pure-button-primary",
submit_label = "Save",
required_span_class = "pure-form-message-inline",
required_span_label = "Required field",
x = as.data.table(
list(
ids = c("user_id", "user_name", "first_name", "last_name", "state"),
types = c("number", "text", "text", "text", "text")
)
),
id_col = "ids",
type_col = "types",
labels = c(user_name = "Account Name"),
select = c("state"),
exclude = c("user_id"),
optional = c("first_name", "last_name"),
custom_input_types = list(user_name = c(type = "email", minlength = 5))
)
}
