% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symBandedToeplitz.R
\name{symBandedToeplitz}
\alias{symBandedToeplitz}
\title{Creates a symmetric banded Toeplitz matrix}
\usage{
symBandedToeplitz(x, n)
}
\arguments{
\item{x}{numeric vector or an object of class \code{\link[dbacf]{dbacf}}.}

\item{n}{integer specifying number of columns (rows) of banded matrix.}
}
\value{
An \eqn{\code{n} \times \code{n}}{n x n} symmetric banded Toeplitz 
matrix whose entries in main band are given by object \code{x}.
}
\description{
Creates a symmetric banded Toeplitz matrix
}
\examples{
alphas <- c(-2, 0.5, -4)
(true.acf <- ARMAacf(ma = alphas))
symBandedToeplitz(true.acf, n = 10)

}
\seealso{
\code{\link[dbacf]{nearPDToeplitz}}, \code{\link[Matrix]{bandSparse}}
}
