#' Generate a Custom Color Palette
#'
#' Returns a vector of distinct colors for use in plotting or annotation.
#' Uses a predefined set of base colors and interpolates additional colors if needed.
#'
#' @param n Integer. Number of colors required.
#'
#' @return A character vector of length \code{n} containing hexadecimal color codes.
#'
#' @keywords internal
get_custom_palette <- function(n) {
  base_palette <- c(
    "#1f78b4",  # blue
    "#e31a1c",  # red
    "#33a02c",  # green
    "#ff7f00",  # bright orange
    "#6a3d9a",  # purple
    "#b15928",  # brown
    "#fdbf6f",  # light orange/yellow
    "#a6cee3",  # light blue/cyan
    "#fb9a99",  # light pink/red
    "#cab2d6",  # lavender
    "#ffff99",  # pale yellow
    "#b2df8a",  # pale green
    "#ff7f7f",  # coral pink
    "#8dd3c7",  # teal
    "#fdae61"   # warm gold
  )
  if (n <= length(base_palette)) {
    return(base_palette[1:n])
  } else {
    return(grDevices::colorRampPalette(base_palette)(n))
  }
}
