% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m2.R
\name{calc_m2}
\alias{calc_m2}
\title{Calculate the M2}
\usage{
calc_m2(
  data,
  struc_params,
  pi_matrix,
  qmatrix,
  ci = 0.9,
  link = "logit",
  model_type = c("LCDM", "GDINA", "ACDM", "LLM", "RRUM", "DINO", "DINA", "BUGDINO")
)
}
\arguments{
\item{data}{A data frame containing the raw data, where there is one row per
respondent and one column per item}

\item{struc_params}{A vector containing the structural parameters of the
estimated model}

\item{pi_matrix}{An item-by-class matrix containing the probability of a
correct response by members of each latent class}

\item{qmatrix}{A data frame containing the Q-matrix}

\item{ci}{The confidence interval for the RMSEA, computed from the M2}

\item{link}{A character containing the link function.}

\item{model_type}{A character containing the model type (e.g., \code{LCDM})
that was estimated.}
}
\value{
A data frame containing:
\itemize{
\item \code{m2}: The M2 statistic
\item \code{df}: Degrees of freedom for the M2 statistic
\item \code{pval}: \emph{p}-value for the M2 statistic
\item \code{rmsea}: Root mean square error of approximation
\item \code{ci_lower}: Lower end of \code{ci} interval for RMSEA
\item \code{ci_upper}: Upper end of \code{ci} interval for RMSEA
\item \code{srmsr}: Standardized root mean square residual
}
}
\description{
Calculate the M2
}
\examples{
possible_prof <- dcm2::as_binary(ncol(sample_data$q_matrix))

fit_dat <- sample_data$data \%>\%
             tidyr::pivot_wider(names_from = "item_id",
                                values_from = "score") \%>\%
             dplyr::select(-"resp_id") \%>\%
             as.matrix() \%>\%
             unname()
gdina_mod <- GDINA::GDINA(dat = fit_dat,
                          Q = data.frame(sample_data$q_matrix),
                          model = "logitGDINA",
                          control = list(conv.type = "neg2LL"))
struc_params <- gdina_mod$struc.parm
pi_matrix <- gdina_mod$LC.prob \%>\%
               as.matrix() \%>\%
               unname()
calc_m2(data = fit_dat, struc_params, pi_matrix,
        qmatrix = data.frame(sample_data$q_matrix), ci = 0.9, link = "logit",
        model_type = "LCDM")

}
