% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample-data.R
\docType{data}
\name{sample_data}
\alias{sample_data}
\title{Simulated Data for Testing Functions}
\format{
A list frame containing 4 \code{tibble} objects:
\itemize{
\item \code{resp_profiles}: A \code{tibble} with 1000 rows and 3 columns. The first
column indicates \code{resp_id} (i.e., the respondent identification number).
The second column indicates \code{att_1} (i.e., a binary indicator for whether the
respondent mastered the first attribute). The third column indicates \code{att_2}
(i.e., a binary indicator for whether the respondent mastered the second
attribute).
\item \code{q_matrix}: A \code{tibble} with 8 rows and 2 columns. Each row corresponds
to an assessment item, and the column entries provide a binary indicator for
whether the item assessed each of the attribute.
\item \code{item_params}: A \code{tibble} with 8 rows and 5 columns. Each row
corresponds to an item. The first column indicates \code{item_id} (i.e., the item
identification number). The second column indicates \code{intercept} (i.e., the
true item intercept parameter for the item). The third column indicates
\code{att_1} (i.e., the true item main effect parameter for the first attribute
for the item). The fourth column indicates \code{att_2} (i.e., the true item main
effect parameter for the second attribute for the item). The fifth column
indicates \code{att_1__att_2} (i.e., the true item interaction effect parameter
for the first and second attributes).
\item \code{data}: A \code{tibble} with 8000 rows and 3 columns. The first column
indicates \code{resp_id} (i.e., the respondent identification number). The second
column indicates \code{item_id} (i.e., the item identification number). The third
column indicates \code{score} (i.e., the dichotomously scored item response).
}
}
\usage{
sample_data
}
\description{
A matrix with randomly simulated data to test the package
functions.
}
\keyword{datasets}
