% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.dcsvm.R
\name{coef.dcsvm}
\alias{coef.dcsvm}
\title{Compute Coefficients for Sparse Density-Convoluted SVM}
\usage{
\method{coef}{dcsvm}(object, s = NULL, type = c("coefficients", "nonzero"), ...)
}
\arguments{
\item{object}{A fitted \code{\link{dcsvm}} object.}

\item{s}{Value(s) of the L1 tuning parameter \code{lambda} for computing coefficients. Default is the entire \code{lambda} sequence obtained by \code{\link{dcsvm}}.}

\item{type}{\code{"coefficients"} or \code{"nonzero"}? \code{"coefficients"} computes the coefficients at given values for \code{s}; \code{"nonzero"} returns a list of the indices of the nonzero coefficients for each value of \code{s}. Default is \code{"coefficients"}.}

\item{...}{Not used. Other arguments to \code{predict}.}
}
\value{
Either the coefficients at the requested values of \code{lambda}, or a list of the indices of the nonzero coefficients for each \code{lambda}.
}
\description{
Computes the coefficients or indices of nonzero coefficients at specified \code{lambda} values from a fitted \code{dcsvm} model.
}
\details{
Compute Coefficients for Sparse Density-Convoluted SVM

Computes the coefficients or returns the indices of nonzero coefficients at chosen values of \code{lambda} from a fitted \code{\link{dcsvm}} object.


\code{s} is the vector of \code{lambda} values at which predictions are requested. If \code{s} is not in the lambda sequence used for fitting the model, the \code{coef} function uses linear interpolation. The new values are interpolated using a fraction of coefficients from both left and right \code{lambda} indices.
}
\examples{
data(colon)
fit <- dcsvm(colon$x, colon$y, lam2=1)
c1 <- coef(fit, type="coefficients", s=c(0.1, 0.005))
c2 <- coef(fit, type="nonzero")

}
\seealso{
\code{\link{predict.dcsvm}}
}
