% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcsvm-package.R
\name{dcsvm-internal}
\alias{dcsvm-internal}
\alias{cv.gaussian}
\alias{cv.uniform}
\alias{cv.epanechnikov}
\alias{cvcompute}
\alias{dcsvm.gauss}
\alias{dcsvm.unif}
\alias{dcsvm.epane}
\alias{err}
\alias{error.bars}
\alias{getmin}
\alias{getoutput}
\alias{lambda.interp}
\alias{lamfix}
\alias{loss.epanechnikov}
\alias{loss.gaussian}
\alias{loss.uniform}
\alias{nonzero}
\alias{zeromat}
\title{Internal DCSVM Functions}
\usage{
cv.gaussian(outlist, lambda, x, y, foldid, pred.loss, hval)
cv.uniform(outlist, lambda, x, y, foldid, pred.loss, hval)
cv.epanechnikov(outlist, lambda, x, y, foldid, pred.loss, hval)
cvcompute(mat, foldid, nlams)
dcsvm.gauss(x, y, alpha, lam2, hval, nlam, flmin, ulam, isd, eps, dfmax, pmax, jd, 
  pfncol, pf, pf2, maxit, istrong, nobs, nvars, vnames)
dcsvm.unif(x, y, alpha, lam2, hval, nlam, flmin, ulam, isd, eps, dfmax, pmax, jd, 
  pfncol, pf, pf2, maxit, istrong, nobs, nvars, vnames)
dcsvm.epane(x, y, alpha, lam2, hval, nlam, flmin, ulam, isd, eps, dfmax, pmax, jd, 
  pfncol, pf, pf2, maxit, istrong, nobs, nvars, vnames)
err(n, maxit, pmax)
error.bars(x, upper, lower, width = 0.02, ...)
getmin(lambda, cvm, cvsd)
getoutput(fit, maxit, pmax, nvars, vnames)
lambda.interp(lambda, s)
lamfix(lam)
loss.epanechnikov(u, hval)
loss.gaussian(u, hval)
loss.uniform(u, hval)
nonzero(beta, bystep = FALSE)
zeromat(nvars, nalam, vnames, stepnames)
}
\description{
These internal functions are not intended for direct use by users. 
For example, \code{err} obtains error messages from Fortran code, 
\code{error.bars} helps to plot cross-validation error curves, 
and \code{getmin} identifies the best \code{lambda} through cross-validation.
Other functions assist with kernel loss computations, coefficient management, and interpolation.
}
\details{
Internal DCSVM Functions

Internal helper functions for the DCSVM package.

Most of these functions are adapted or directly copied from the \code{gcdnet} and \code{glmnet} packages.
}
\keyword{internal}
