% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.dcsvm.R
\name{cv.dcsvm}
\alias{cv.dcsvm}
\title{Cross-Validation for Sparse Density-Convoluted SVM}
\usage{
cv.dcsvm(x, y, lambda = NULL, hval = 1, 
  pred.loss = c("misclass", "loss"), nfolds = 5, foldid, ...)
}
\arguments{
\item{x}{A matrix of predictors, i.e., the \code{x} matrix used in \code{\link{dcsvm}}.}

\item{y}{A vector of binary class labels, i.e., the \code{y} used in \code{\link{dcsvm}}.}

\item{lambda}{Default is \code{NULL}, and the sequence generated by \code{\link{dcsvm}} is used. User can also provide a new \code{lambda} sequence for cross-validation.}

\item{hval}{The bandwidth parameter for kernel smoothing. Default is 1.}

\item{pred.loss}{\code{"misclass"} for classification error, \code{"loss"} for the density-convoluted SVM loss.}

\item{nfolds}{The number of folds. Default is 5. The allowable range is from 3 to the sample size. Larger \code{nfolds} increases computational time.}

\item{foldid}{An optional vector with values between 1 and \code{nfold}, representing the fold indices for each observation. If supplied, \code{nfolds} can be missing.}

\item{...}{Other arguments that can be passed to \code{\link{dcsvm}}.}
}
\value{
A \code{\link{cv.dcsvm}} object is returned, which includes the cross-validation fit:
  \item{lambda}{The \code{lambda} sequence used in \code{\link{dcsvm}}.}
  \item{cvm}{A vector of length \code{length(lambda)} for the mean cross-validated error.}
  \item{cvsd}{A vector of length \code{length(lambda)} for estimates of standard error of \code{cvm}.}
  \item{cvupper}{The upper curve: \code{cvm + cvsd}.}
  \item{cvlower}{The lower curve: \code{cvm - cvsd}.}
  \item{nzero}{Number of non-zero coefficients at each \code{lambda}.}
  \item{name}{"Mis-classification error", for plotting purposes.}
  \item{dcsvm.fit}{A fitted \code{\link{dcsvm}} object using the full data.}
  \item{lambda.min}{The \code{lambda} incurring the minimum cross-validation error \code{cvm}.}
  \item{lambda.1se}{The largest value of \code{lambda} such that error is within one standard error of the minimum.}
  \item{cv.min}{The minimum cross-validation error.}
  \item{cv.1se}{The cross-validation error associated with \code{lambda.1se}.}
}
\description{
Performs cross-validation for the sparse density-convoluted SVM to estimate the optimal tuning parameter \code{lambda}.
}
\details{
Cross-Validation for Sparse Density-Convoluted SVM

Conducts a k-fold cross-validation for \code{\link{dcsvm}} and returns the suggested values of the L1 parameter \code{lambda}.


This function runs \code{\link{dcsvm}} on the sparse density-convoluted SVM by excluding each fold in turn, then computes the mean cross-validation error and standard deviation. It is adapted from the \code{cv} functions in the \code{gcdnet} and \code{glmnet} packages.
}
\examples{
data(colon)
colon$x <- colon$x[ ,1:100] # Use only the first 100 columns for this example
n <- nrow(colon$x)
set.seed(1)
id <- sample(n, trunc(n / 3))
cvfit <- cv.dcsvm(colon$x[-id, ], colon$y[-id], lam2=1, nfolds=5)
plot(cvfit)
predict(cvfit, newx=colon$x[id, ], s="lambda.min")

}
\seealso{
\code{\link{dcsvm}}, \code{\link{plot.cv.dcsvm}}, \code{\link{predict.cv.dcsvm}}, and \code{\link{coef.cv.dcsvm}} methods.
}
