% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eclairs_reform.R
\name{reform_decomp}
\alias{reform_decomp}
\title{Recompute eclairs after dropping features}
\usage{
reform_decomp(ecl, k = ecl$k, drop = NULL)
}
\arguments{
\item{ecl}{covariance/correlation matrix as an \link{eclairs} object}

\item{k}{the rank of the low rank component}

\item{drop}{array of variable names to drop.}
}
\value{
\link{eclairs} decomposition for a subset of features
}
\description{
Recompute eclairs after dropping features
}
\details{
Reform the dataset from the eclairs decomposition, drop features, then recompute the eclairs decomposition.  If the original SVD/eigen was truncated, then the reconstruction of the original data will be approximate.  Note that the target shrinkage matrix is the same as in \code{ecl}, so \eqn{\nu} is not recomputed from the retained features.
}
\examples{
library(Rfast)

n <- 800 # number of samples
p <- 200 # number of features

# create correlation matrix
Sigma <- autocorr.mat(p, .9)

# draw data from correlation matrix Sigma
Y <- rmvnorm(n, rep(0, p), sigma = Sigma * 5.1, seed = 1)
rownames(Y) <- paste0("sample_", seq(n))
colnames(Y) <- paste0("gene_", seq(p))

# Correlation
#------------

# eclairs decomposition
Sigma.eclairs <- eclairs(Y, compute = "correlation")

# features to drop
drop <- paste0("gene_", 1:100)

# Compute SVD on subset of eclairs decomposition
ecl1 <- reform_decomp(Sigma.eclairs, drop = drop)

ecl1

}
