% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alias-deeptrafo.R
\name{cotramNN}
\alias{cotramNN}
\title{Deep distribution-free count regression}
\usage{
cotramNN(
  formula,
  data,
  response_type = get_response_type(data[[all.vars(formula)[1]]]),
  order = get_order(response_type, data[[all.vars(formula)[1]]]),
  addconst_interaction = 0,
  latent_distr = "logistic",
  monitor_metrics = NULL,
  ...
)
}
\arguments{
\item{formula}{Formula specifying the response, interaction, shift terms
as \code{response | interacting ~ shifting}.
auto-regressive transformation models (ATMs).}

\item{data}{Named \code{list} or \code{data.frame} which may contain both
structured and unstructured data.}

\item{response_type}{Character; type of response. One of \code{"continuous"},
\code{"survival"}, \code{"count"}, or \code{"ordered"}. If not supplied
manually it is determined by the first entry in \code{data[[response]]}.}

\item{order}{Integer; order of the response basis. Default 10 for Bernstein
basis or number of levels minus one for ordinal responses.}

\item{addconst_interaction}{Positive constant;
a constant added to the additive predictor of the interaction term.
If \code{NULL}, terms are left unchanged. If 0 and predictors have
negative values in their design matrix, the minimum value of all predictors
is added to ensure positivity. If > 0, the minimum value plus the
\code{addconst_interaction} is added to each predictor in the interaction
term. This ensures a monotone non-decreasing transformation function in
the response when using (tensor product) spline bases in the interacting
term.}

\item{latent_distr}{A \code{tfd_distribution} or character; the base distribution for
transformation models. If character, can be \code{"normal"}, \code{"logistic"},
\code{"gumbel"} or \code{"gompertz"}.}

\item{monitor_metrics}{See \code{\link[deepregression]{deepregression}}}

\item{...}{Additional arguments passed to \code{deepregression}}
}
\value{
See return statement of \code{\link[deeptrafo]{deeptrafo}}
}
\description{
Deep distribution-free count regression
}
\examples{
if (.Platform$OS.type != "windows" &&
    reticulate::py_available() &&
    reticulate::py_module_available("tensorflow") &&
    reticulate::py_module_available("keras") &&
    reticulate::py_module_available("tensorflow_probability")) {
    set.seed(1)
    df <- data.frame(y = as.integer(abs(1 + rnorm(50, sd = 10))), x = rnorm(50))
    m <- cotramNN(y ~ 0 + x, data = df, order = 6)
\donttest{
    optimizer <- optimizer_adam(learning_rate = 0.1, decay = 4e-4)
    m <- cotramNN(y ~ 0 + x, data = df, optimizer = optimizer, order = 6)
    library(cotram)
    fit(m, epochs = 800L, validation_split = 0)
    logLik(mm <- cotram(y ~ x, data = df, method = "logit")); logLik(m)
    coef(mm, with_baseline = TRUE); unlist(c(coef(m, which = "interacting"),
                                             coef(m, which = "shifting")))
}
}

}
