% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simDegrossData.R
\name{simDegrossData}
\alias{simDegrossData}
\title{Simulation of grouped data and their sample moments to illustrate the \link{degross} density estimation procedure}
\usage{
simDegrossData(n, plotting=TRUE, choice=2, J=3)
}
\arguments{
\item{n}{Desired sample size}

\item{plotting}{Logical indicating whether the histogram of the simulated data should be plotted. Default: FALSE}

\item{choice}{Integer in 1:3 indicating from which mixture of distributions to generate the data}

\item{J}{Number of big bins}
}
\value{
A list containing tabulated frequencies and central moments of degrees 1 to 4 for data generated using a mixture density. This list contains :
\itemize{
\item{\code{n} : \verb{ }}{total sample size.}
\item{\code{J} : \verb{ }}{number of big bins.}
\item{\code{Big.bins} : \verb{ }}{vector of length \code{J+1} with the big bin limits.}
\item{\code{freq.j} : \verb{ }}{vector of length \code{J} with the observed big bin frequencies.}
\item{\code{m.j} : \verb{ }}{\code{J} by \code{4} matrix with on each row the observed first four sample central moments within a given big bin.}
\item{\code{true.density} : \verb{ }}{density of the raw data generating mechanism (to be estimated from the observed grouped data).}
\item{\code{true.cdf} : \verb{ }}{cdf of the raw data generating mechanism (to be estimated from the observed grouped data).}
}
}
\description{
Simulation of grouped data and their sample moments to illustrate the \link{degross} density estimation procedure
}
\examples{
## Generate data
sim = simDegrossData(n=3500, plotting=TRUE, choice=2, J=3)
print(sim$true.density) ## Display density of the data generating mechanism

# Create a degrossData object
obj.data = with(sim, degrossData(Big.bins=Big.bins, freq.j=freq.j, m.j=m.j))
print(obj.data)

}
\references{
Lambert, P. (2021) Moment-based density and risk estimation from grouped summary statistics. arXiv:2107.03883.
}
\seealso{
\code{\link{degrossData}}.
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
