% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.interpolation.R
\name{network.interpolation}
\alias{network.interpolation}
\title{Interpolation of NA values using the dendrometer network}
\usage{
network.interpolation(df, referenceDF, niMethod)
}
\arguments{
\item{df}{dataframe with first column containing date and time in the format \code{yyyy-mm-dd HH:MM:SS} and dendrometer data in the second column and onward. The data gaps must be filled with \code{NA} using the gap.interpolation function.}

\item{referenceDF}{dataframe with other dendrometers to be used as reference for the interpolation. The more dendrometers are included, the more robust will be the interpolation.}

\item{niMethod}{string, either \emph{'linear'} or \emph{'proportional'} for interpolation method.}
}
\value{
A dataframe with \code{NA} values replaced by interpolated data.
}
\description{
A function to interpolate the missing data of a dendrometer with the help of other dendrometers from the same site, provided they have the same measurement period and temporal resolution.
}
\examples{
\donttest{library(dendRoAnalyst)
data("gf_nepa17")
df1<-gf_nepa17
# Creating an artificial reference dataset.
df2<-cbind(gf_nepa17,gf_nepa17[,2:3],gf_nepa17[,2:3])
colnames(df2) <- c('Time','T1','T2','T3','T4','T5','T6')
# Creating gaps in dataset by replacing some of the reading with NA in dataset.
df1[40:50,3]<-NA
# Using proportional interpolation method.
df1_NI<-network.interpolation(df=df1, referenceDF=df2, niMethod='proportional')
head(df1_NI,10)}

}
