% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_missing.R
\name{impute_missing}
\alias{impute_missing}
\title{Impute Missing Values in a Data Frame}
\usage{
impute_missing(data, method = NULL)
}
\arguments{
\item{data}{A data frame containing numeric and/or categorical variables with missing values.}

\item{method}{A character string specifying the imputation method for numeric columns.
Options are \code{"mean"}, \code{"median"}, \code{"regression"}, or \code{NULL} (default: \code{NULL}).}
}
\value{
A data frame with missing values imputed according to the specified method.
}
\description{
This function imputes missing values in a data frame.
For categorical variables (factor or character), missing values are replaced with the mode.
For numeric variables, missing values can be imputed using the mean, median, or regression-based imputation.
If no method is specified for numeric columns, missing values are left as NA.
}
\examples{
library(dplyr)
# Impute numeric columns using regression and categorical with mode
impute_missing(starwars, method = "regression")

# Impute numeric columns using mean
impute_missing(starwars, method = "mean")

# Impute numeric columns using median
impute_missing(starwars, method = "median")
}
