% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_autoscaling.R
\name{mk_autoscale_function}
\alias{mk_autoscale_function}
\title{Create a function that transforms a current (multi-dimensional) score into a boxcox normalized one}
\usage{
mk_autoscale_function(
  batch_container,
  scoring,
  random_perm,
  use_boxcox = TRUE,
  sample_attributes_fixed = FALSE
)
}
\arguments{
\item{batch_container}{An instance of \link{BatchContainer}.}

\item{scoring}{A named \code{\link[=list]{list()}} of scoring function. Each function should
return a vector of non-zero length.}

\item{random_perm}{Number of random sample permutations for the estimation of the scaling params.}

\item{use_boxcox}{Logical; if TRUE and the \code{bestNormalize} package is available, boxcox transformations will be used to
normalize individual scores. If not possible, scores will just be transformed to a zero mean and unit standard deviation.}

\item{sample_attributes_fixed}{Logical; if FALSE, simulate a shuffle function that alters sample attributes at each iteration.}
}
\value{
The transformation function for a new score vector
}
\description{
Create a function that transforms a current (multi-dimensional) score into a boxcox normalized one
}
\keyword{internal}
