% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_scatter.R
\name{show_scatter}
\alias{show_scatter}
\title{2D and 3D Scatter Plot Display for Tours}
\usage{
show_scatter(
  x,
  ...,
  palette = viridis,
  center = TRUE,
  axes = TRUE,
  edges = NULL,
  paused = TRUE,
  scale_factor = NULL
)
}
\arguments{
\item{x}{a \code{detour} object}

\item{...}{used to support aesthetic parameters for the plot, including
\itemize{
\item size: point size, defaults to 1
\item alpha: point opacity, defaults to 1
\item background_colour: defaults to "white"
\item edge_colour: colour of edges, defaults to black
\item edge_width: width of edges, defaults to 1
}}

\item{palette}{Colour palette to use with the colour aesthetic. Can be:
\itemize{
\item A character vector of R colours. This should match the number of levels
of the colour aesthetic, or the number of bins to use for continuous colours.
\item A function which takes the number of colours to use as input and returns a
character vector of colour names and / or hex values as output.
}}

\item{center}{If TRUE, center the projected data to (0, 0, 0).}

\item{axes}{Can be one of:
\itemize{
\item \code{TRUE} draw axes and use column names for axis labels
\item \code{FALSE} do not draw axes or labels
\item \code{NULL} draw axes with no labels
\item An unnamed vector of labels with the same length as \code{cols}
\item A named vector in the form \code{c("h" = "head")}, where \code{head} is renamed to
\code{h}
}}

\item{edges}{A two column numeric matrix giving indices of ends of lines.}

\item{paused}{whether the widget should be initialised in the 'paused' state}

\item{scale_factor}{used as a multiplier for the point coordinates so they
are displayed on a sensible range. Defaults to the reciprocal of maximum distance
from a point to the origin.}
}
\value{
An object of class \code{htmlwidget}
}
\description{
Display method for a high performance 2D or 3D scatter plot.
Performance is achieved through the use of Three.js / WebGL, and the 2D or
3D variant is selected automatically based on the tour generator provided.
}
\details{
This display method produces an interactive scatterplot animation which
supports both 2D and 3D tours. Linked selection and filtering is also
supported using crosstalk. The set of interactive controls available are:
\itemize{
\item A timeline with a play / pause button and indicators at the position of
each basis used. The basis indicators can be hovered with the mouse to show
the index of the basis, or clicked to jump to that basis. The timeline
also allows for clicking and dragging of the scrubber to move to any
individual frame of the animation.
\item Orbit controls. For the 2D variant, this allows the projection to be
rotated by clicking and dragging from left to right. For the 3D variant,
full orbit controls are available by clicking and dragging. For both orbit
and pan controls, the scroll wheel can be used to zoom.
\item Pan controls, which work similarly to orbit controls but move the camera
laterally / vertically rather than rotating
\item Resetting of the orbit and pan controls
\item Selection and highlighting. Multiple selection is possible by using the
shift key
\item Colouring / brushing of highlighted points
}
}
\examples{
detour(tourr::flea, tour_aes(projection = -species, colour = species)) |>
  tour_path(grand_tour(3), fps = 60) |>
  show_scatter(alpha = 0.7, axes = FALSE)
}
