% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sharpeDeMichele_77}
\alias{sharpeDeMichele_77}
\title{Sharpe and DeMichele equation of development rate as a function of temperature.}
\format{
A list of eight elements describing the equation.
\describe{
  \item{eq}{The equation (formula object).}
  \item{eqAlt}{The equation (string).}
  \item{name}{The name of the equation.}
  \item{ref}{The equation reference.}
  \item{refShort}{The equation reference shortened.}
  \item{startVal}{The parameters found in the literature with their references.}
  \item{com}{An optional comment about the equation use.}
  \item{id}{An id to identify the equation.}
}
}
\usage{
sharpeDeMichele_77
}
\description{
Sharpe, P.J. & DeMichele, D.W. (1977) Reaction kinetics of poikilotherm development.
Journal of Theoretical Biology, 64, 649-670.
}
\details{
Equation:
\deqn{rT = \frac{(T + 273.16) * e^{\frac{aa - \frac{bb}{T + 273.16}}{1.987}}}{1 + e^{\frac{cc - \frac{dd}{T + 273.16}}{1.987}} + e^{\frac{ff - \frac{gg}{T + 273.16}}{1.987}}}}{%
      rT = ((T + 273.16) * exp((aa - bb/(T + 273.16))/1.987)) / (1 + exp((cc - dd/(T + 273.16))/1.987) + exp((ff - gg/(T + 273.16))/1.987))}

where rT is the development rate, T the temperature, and aa, bb, cc,
dd, ff, and gg thermodynamic parameters.
}
\references{
\doi{10.1016/0022-5193(77)90265-X}
}
\keyword{datasets}
