% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/option.R
\name{load_options}
\alias{load_options}
\title{Load Options Table from a File}
\usage{
load_options(file_name)
}
\arguments{
\item{file_name}{A \code{character} string specifying the file from which to
load the options matrix.}
}
\value{
A \code{matrix} representing the loaded options.
}
\description{
Retrieves a matrix of options saved in a file. This matrix can then be used
for further analysis or processing.
}
\examples{
tree <- dexisensitivity::masc2
option <- create_options(tree, num_options=3, seed = 42)
save_options(option,paste0(tempdir(),"\\\\save_options.tab"))
loaded_option <- load_options(paste0(tempdir(),"\\\\save_options.tab"))
file.remove(paste0(tempdir(),"\\\\save_options.tab"))

}
