% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oat.R
\name{oat}
\alias{oat}
\title{OFAT Sensitivity Analysis}
\usage{
oat(tree, option)
}
\arguments{
\item{tree}{\code{Tree} object designated for analysis.}

\item{option}{Initial configuration for \code{Tree} parameters.}
}
\value{
A \code{matrix} depicting the assessment outcomes for every attribute
in the \code{Tree}, corresponding to diverse parameter alterations.
}
\description{
Executes a One-Factor-At-A-Time (OFAT) sensitivity assessment by undertaking
simulations while varying individual factors. During each simulation, all
factors are maintained constant save for one.
}
\examples{
tree <- dexisensitivity::masc2
optionOAT <- create_options(tree, 1)
results <- oat(tree, optionOAT)

}
