% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretty.R
\name{pretty_time_taken}
\alias{pretty_time_taken}
\title{Calculate elapsed time between two points and present prettily}
\usage{
pretty_time_taken(start_time, end_time)
}
\arguments{
\item{start_time}{start time readable by as.POSIXct}

\item{end_time}{end time readable by as.POSIXct}
}
\value{
string containing prettified elapsed time
}
\description{
Converts a start and end value to a readable time format.
}
\details{
Designed to be used with Sys.time() when tracking start and end times.

Shows as seconds up until 119 seconds, then minutes until 119 minutes,
then hours for anything larger.

Input start and end times must be convertible to POSIXct format.
}
\examples{
pretty_time_taken(
  "2024-03-23 07:05:53 GMT",
  "2024-03-23 12:09:56 GMT"
)

# Track the start and end time of a process
start <- Sys.time()
Sys.sleep(0.1)
end <- Sys.time()

# Use this function to present it prettily
pretty_time_taken(start, end)
}
\seealso{
\code{\link[=comma_sep]{comma_sep()}} \code{\link[=round_five_up]{round_five_up()}} \code{\link[=as.POSIXct]{as.POSIXct()}}

Other prettying: 
\code{\link{pretty_filesize}()},
\code{\link{pretty_num}()},
\code{\link{pretty_num_table}()}
}
\concept{prettying}
