% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfmirror_func.R
\name{simulate_dataframe}
\alias{simulate_dataframe}
\title{Simulate data that mirrors a data frame and output code to re-create the simulation}
\usage{
simulate_dataframe(
  input_df,
  num_obs = 1,
  columns_to_simulate = colnames(input_df),
  hide_cols = FALSE,
  seed = NULL
)
}
\arguments{
\item{input_df}{A data frame.}

\item{num_obs}{A numeric value specifying how many observations (i.e., rows) to simulate.}

\item{columns_to_simulate}{One or more columns from the \code{input_df} to simulate. The default is all columns.}

\item{hide_cols}{Select \code{TRUE} to replace column names with anonymized names that take the form of "v1," "v2," and so on for each column.}

\item{seed}{Optional random seed for reproducibility}
}
\value{
A list with
\itemize{
\item \code{simulated_df} a data frame object containing a simulated mirror of the input df where each specified column has the same mean and standard deviation as the input df
\item \code{code} a string vector that can be run in conjunction with \code{cat()} to output easily shareable code to recreate \code{simulated_df}
}
}
\description{
Simulate data that mirrors a data frame and output code to re-create the simulation
}
\examples{
# # Run the function and create an object called `mirrored_df`
mirrored_df <- simulate_dataframe(mtcars, num_obs = 10, columns_to_simulate = c("mpg", "wt"))

# Print the mirrored data frame
print(mirrored_df$simulated_df)

# Output code to create the mirrored data frame for asking
# questions or supporting other reproducible tasks
cat(mirrored_df$code)
}
