% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSATBtest.R
\docType{data}
\name{MSATBtest}
\alias{MSATBtest}
\title{Dataset of School Admission Test in Biology.}
\format{
A \code{MSATBtest} data frame consists of 1,407 observations on the following 21 variables:
\describe{
\item{Item}{nominal items of the test}
\item{gender}{gender of respondents, \code{"0"} males, \code{"1"} females}
}
}
\usage{
data(MSATBtest)
}
\description{
The \code{MSATBtest} dataset consists of the responses of 1,407 subjects (484 males, 923 females)
to multiple-choice admission test to medical school in the Czech republic. It contains 20 selected items from original
test while first item was previously detected detected as differently functioning (Vlckova, 2014).
Possible answers were A, B, C, and D, while any combination of these can be correct. The column \code{gender} represents
gender of students, where 0 indicates males (reference group) and 1 indicates females (focal group).
}
\references{
Drabinova, A. & Martinkova, P. (2017). Detection of differential item functioning with nonlinear regression:
A non-IRT approach accounting for guessing. Journal of Educational Measurement, 54(4), 498--517,
\doi{10.1111/jedm.12158}.

Vlckova, K. (2014). Test and item fairness. Master's thesis. Faculty of Mathematics and Physics, Charles University.
}
\seealso{
\code{\link{MSATB}}, \code{\link{MSATBkey}}
}
\author{
Adela Hladka (nee Drabinova) \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr
}
\keyword{datasets}
