% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffusion.R
\name{diffusion}
\alias{diffusion}
\title{Fit various diffusion curves.}
\usage{
diffusion(
  y,
  w = NULL,
  cleanlead = c(TRUE, FALSE),
  loss = 2,
  cumulative = c(TRUE, FALSE),
  verbose = c(FALSE, TRUE),
  type = c("bass", "gompertz", "gsgompertz", "weibull"),
  method = c("L-BFGS-B", "Nelder-Mead", "BFGS", "hjkb", "Rcgmin", "bobyqa"),
  maxiter = 500,
  opttol = 1e-06,
  multisol = c(FALSE, TRUE),
  initpar = c("linearize", "preset"),
  mscal = c(TRUE, FALSE),
  ...
)
}
\arguments{
\item{y}{vector with adoption per period}

\item{w}{vector of curve parameters (see note). Parameters set to NA will be
optimized. If \code{w = NULL} (default) all paramters are optimized.}

\item{cleanlead}{removes leading zeros for fitting purposes (default == TRUE)}

\item{loss}{the l-norm (1 is absolute errors, 2 is squared errors).}

\item{cumulative}{If TRUE optimisation is done on cumulative adoption.}

\item{verbose}{if TRUE console output is provided during estimation (default == FALSE)}

\item{type}{diffusion curve to use. This can be "bass", "gompertz" and "gsgompertz"}

\item{method}{optimization method to use. These can be \code{"Nelder-Meade"},
\code{"L-BFGS-B"}, \code{"BFGS"}, \code{"hjkb"}, \code{"Rcgmin"},
\code{"bobyqa"}. Typically, good performance is achieved with
\code{"Nelder-Meade"} and \code{"L-BFGS-B"}. \code{"hjkb"} and
\code{"Rcgmin"} might be an alternative for complex shapes but have
substantially higher computational costs. For further details on
optimization algorithms we refer to the optimx package documentation}

\item{maxiter}{number of iterations the optimiser takes (default == \code{5000})}

\item{opttol}{Tolerance for convergence (default == 1.e-06)}

\item{multisol}{when \code{"TRUE"} multiple optmisation solutions from
different initialisations of the market parameter are used (default ==
\code{"FALSE"})}

\item{initpar}{vector of initalisation parameters. If set to \code{preset} a
predfined set of internal initalisation parameters is used while
\code{"linearize"} uses linearized initalisation methods (default == \code{"linearize"}.}

\item{mscal}{scales market potential at initalisation with the maximum of the
observed market potential for better optimization results (default == \code{TRUE})}

\item{...}{accepts \code{pvalreps}, bootstrap repetitions to estimate
(marginal) p-values; \code{eliminate}, if TRUE eliminates insignificant
parameters from the estimation (forces \code{pvalreps = 1000} if left to 0)
\code{sig}, significance level used to eliminate parameters.}
}
\value{
Returns an object of class \code{diffusion}, which contains:
\itemize{
\item \code{type} diffusion curve type used
\item \code{call} calls function fitted
\item \code{w} named vector of fitted parameters
\item \code{y} actuals
\item \code{fit} fitted values of model
\item \code{frc} forecasts for future periods. This is \code{NULL} until \code{\link{predict.diffusion}} is called.
\item \code{mse} insample Mean Squared Error
\item \code{prew} the \code{w} of the previous generation
\item \code{pval} p-values for \code{w}
\item \code{init} the initial values that have been used for the optimizer
}
}
\description{
This function fits diffusion curves that can be of \code{"bass"}, 
\code{"gompertz"}, \code{"gsgompertz"} (Gamma/Shifted Gompertz curve) or \code{"Weibull"} type.
}
\note{
vector \code{w} needs to be provided for the Bass curve in the order of
  \code{"m", "p", "q"}, where "p" is the coefficient of innovation, "q" is the
  coefficient of imitation and "m" is the market size coefficient.
  
  For the Gompertz curve, vector \code{w} needs to be in the form of
  \code{("m", "a", "b")}. Where "a" is the x-axis displacement coefficient, "b"
  determines the growth rate and "m" sets, similarly to the Bass curve, the
  market potential (saturation point).
  
  For the Shifted-Gompertz curve, vector \code{w} needs to be in the form of 
  \code{("m", "a", "b", "c")}. Where "a" is the x-axis displacement
  coefficient, "b" determines the growth rate, "c" is the shifting parameter
  and "m" sets, similarly to the Bass curve, the market potential (saturation
  point).
  
  For the Weibull curve, vector \code{w} needs to be in the form of
  \code{("m", "a", "b")}. Where "a" is the scale parameter, "b" determines the
  shape. Together, "a" and "b" determine the steepness of the curve. The "m"
  parameter sets the market potential (saturation point).

Parameters are estimated by 
minimising the Mean Squared Error with a subplex algorithm from the optimx package. 
Optionally p-values of the coefficients can be determined via
bootstraping. Furthermore, the bootstrapping allows removing insignificant
parameters from the optimization process.
}
\section{Bass curve}{

The optimization of the Bass curve is initialized by the linear
approximation suggested in Bass (1969).
}

\section{Gompertz curve}{

The initialization of the Gompertz curve uses the
approach suggested by Jukic et al. (2004), but is adapted to allow for the
non-exponential version of the Gompertz curve. This makes the market potential
parameter equivalent to the Bass curves and the market potential from
Bass curve is used for initialization.
}

\section{Gamma/Shifted Gompertz}{

The curve is initialized by assuming the shift operator to be 1 and 
becomes equivalent to the Bass curve, as shown in Bemmaor (1994). A Bass
curve is therefore used as an estimator for the remaining initial parameters.
}

\section{Weibull}{

The initialization is obtained through by a linear approximation
median-ranked OLS described in Sharif and Islam 1980.
}

\examples{
 fitbass <- diffusion(diff(tsChicken[, 2]), type = "bass")
 fitgomp <- diffusion(diff(tsChicken[, 2]), type = "gompertz")
 fitgsg <- diffusion(diff(tsChicken[, 2]), type = "gsgompertz")
 fitgwb <- diffusion(diff(tsChicken[, 2]), type = "weibull")
 
 # Produce some plots
 plot(fitbass)
 plot(fitgomp)
 plot(fitgsg)
 plot(fitgwb)

}
\references{
\itemize{
\item{For an introduction to diffusion curves see Ord K., Fildes R., Kourentzes N. (2017) \href{https://wessexlearning.com/products/principles-of-business-forecasting-2nd-ed}{Principles of Business Forecasting 2e}. \emph{Wessex Press Publishing Co.}, Chapter 12.}
\item{Bass, F.M., 1969. A new product growth for model consumer durables. Management Science 15(5), 215-227.}
\item{Bemmaor, A. 1994. Modeling the Diffusion of New Durable Goods: Word-of-Mouth Effect versus Consumer Heterogeneity. In G. Laurent, G.L. Lilien and B. Pras (Eds.). Research Traditions in Marketing. Boston: Kluwer, pp. 201-223.}
\item{Jukic, D., Kralik, G. and Scitovski, R., 2004. Least-squares fitting Gompertz curve. Journal of Computational and Applied Mathematics, 169, 359-375.}
\item{Sharif, N.M. and Islam, M.N. 1980. The Weibull Distribution as a General Model for Forecasting Technological Change. Technological Forecasting and Social Change, 18, 247-256.}
}
}
\seealso{
\code{\link{predict.diffusion}}, \code{\link{plot.diffusion}} and \code{\link{print.diffusion}}.

\code{\link{seqdiffusion}} for sequential diffusion model fitting
 across product generations.
}
\author{
Oliver Schaer, \email{info@oliverschaer.ch},

Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}
}
