% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date_xx.R, R/date_y.R, R/date_ym.R,
%   R/date_yq.R, R/date_yw.R
\name{as.Date.date_xx}
\alias{as.Date.date_xx}
\alias{as.POSIXlt.date_xx}
\alias{as.POSIXct.date_xx}
\alias{Sys.date_yq}
\alias{Sys.date_ym}
\alias{Sys.date_yw}
\alias{as.Date.date_y}
\alias{as.Date.date_ym}
\alias{as.Date.date_yq}
\alias{as.Date.date_yw}
\title{Coerce dint Objects to Base R Date Types}
\usage{
\method{as.POSIXlt}{date_xx}(x, tz = "UTC", ...)

\method{as.POSIXct}{date_xx}(x, tz = "UTC", ...)

Sys.date_yq()

Sys.date_ym()

Sys.date_yw()

\method{as.Date}{date_y}(x, ...)

\method{as.Date}{date_ym}(x, ...)

\method{as.Date}{date_yq}(x, ...)

\method{as.Date}{date_yw}(x, ...)
}
\arguments{
\item{x}{any \R object}

\item{tz}{a character string.  The time zone specification to be used
    for the conversion, \emph{if one is required}.  System-specific (see
    \link[base]{time zones}), but \code{""} is the current time zone, and
    \code{"GMT"} is UTC (Universal Time, Coordinated).  Invalid values
    are most commonly treated as UTC, on some platforms with a warning.}

\item{...}{passed on to methods}
}
\value{
An Object of the appropriate base \R type (\code{Date}, \code{POSIXct}, or
\code{POSIXlt})
}
\description{
All \pkg{dint} objects can be coerced to base R Date or Datetime (\code{POSIXct})
types. The resulting date will always default to the first possible
Date/Datetime in this period.
}
\details{
If \pkg{lubridate} is loaded, methods for lubridate generics (such as
\code{\link[lubridate:month]{lubridate::month()}} and \code{\link[lubridate:year]{lubridate::year()}}) are also made available by
dint.
}
\examples{
as.Date(date_yq(2017, 2))
as.POSIXlt(date_yq(2017, 2))

# When coercing to datetime, the default timezone is UTC
as.POSIXct(date_yq(2017, 2))
}
