% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_odds_against.R
\name{prep_odds_against}
\alias{prep_odds_against}
\title{Calculate odds against values for \code{x_axis} for probability discounting}
\usage{
prep_odds_against(dat, x_axis, groupings = NULL)
}
\arguments{
\item{dat}{Discounting data tibble. \code{AUC_zeroes} should be run first if
zero values on the \code{x_axis} will need to be included.}

\item{x_axis}{Probabilities distance variable}

\item{groupings}{Variables for grouping (e.g., subject, expeirmental group)
as a character or vector of characters}
}
\value{
Original data frame (a tibble) that includes an appended column odds against
}
\description{
Calculate odds against values for \code{x_axis} for probability discounting
}
\examples{
prep_odds_against(examp_PD,
  "prob",
  groupings = c("subject", "outcome")
)
}
