% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscSurvPlot.R
\name{plotSurv}
\alias{plotSurv}
\title{Plot Estimated Survival Function}
\usage{
plotSurv(hazards, ...)
}
\arguments{
\item{hazards}{Estimated discrete hazards ("numeric vector")}

\item{...}{Further arguments passed to \code{\link{plot}}.}
}
\description{
Generates a plot of an estimated survival function S(T>t|x) based on estimated discrete hazards.
}
\examples{
# Example unemployment data
library(Ecdat)
data(UnempDur)

# Select subsample
subUnempDur <- UnempDur [1:100, ]

# Convert to long format
UnempLong <- dataLong(dataShort = subUnempDur, timeColumn = "spell", eventColumn = "censor1")
head(UnempLong)

# Estimate binomial model with logit link
Fit <- glm(formula = y ~ timeInt + age + logwage, data = UnempLong, family = binomial())

# Estimate discrete survival function given age, logwage of first person
Tmax   <- max(subUnempDur$spell)
UnempEval <- dataLong(dataShort = UnempDur[1,], timeColumn = "spell", eventColumn = "censor1", 
aggTimeFormat = TRUE, lastTheoInt = Tmax)
hazard <- predict(Fit, newdata = UnempEval, type = "response")

plotSurv(hazard)



}
\references{
\insertRef{tutzModelDisc}{discSurv}
}
\seealso{
\code{\link{estSurv}}
}
\author{
Moritz Berger \email{moritz.berger@imbie.uni-bonn.de} \cr \url{https://www.imbie.uni-bonn.de/personen/dr-moritz-berger/}
}
\keyword{discrete}
\keyword{survival}
