% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{weibdata10040}
\alias{weibdata10040}
\title{Hierarchical time-to-event data simulated from a Weibull baseline distribution with a nonparametric frailty}
\format{
A data frame with 4000 rows and the following columns

\describe{
\item{family}{Integer from 1 to 100 indicating the group membership.  There are 40 individuals in each group.}
\item{time}{Survival time}
\item{status}{Indicator for an observed event at the survival time}
\item{x}{Covariate value, generated from a standard normal distribution}
\item{belong}{Underlying group-specific frailty value}
}

There are two underlying latent populations with proportion 0.8 and 0.2 with frailty values 0.8 and 1.6 respectively, thus the second population has twice the hazard of the first.  The covariate is associated with a log hazard ratio of 1.6.

The baseline hazard is set to that of a Weibull model.

The percentage of censored events is equal to 20.

The dataset was generated by \code{\link{sim_weibdf}} as follows.

\code{sim_weibdf( J = 100, N = 40, lambda = 0.3, rho = 1.3, beta = 1.6, p = c( 0.8, 0.2 ), w_values = c( 0.8, 1.6 ), cens_perc = 0.2)}
}
\usage{
weibdata10040
}
\description{
Hierarchical time-to-event data simulated from a Weibull baseline distribution with a nonparametric frailty
}
\keyword{datasets}
