% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovr_data.R
\docType{data}
\name{ocd}
\alias{ocd}
\title{OCD data}
\format{
A tibble with 30 rows and 4 variables.
}
\source{
\href{https://www.discovr.rocks/csv/ocd.csv}{www.discovr.rocks/csv/ocd.csv}
}
\usage{
ocd
}
\description{
A dataset from Field, A. P. (2026). Discovering statistics using R and RStudio (2nd ed.). London: Sage.
}
\details{
Fictitious data about interventions for obsessive compulsive disorder. Obsessive compulsive disorder (OCD) is a mental health problem characterized
by intrusive images or thoughts that the sufferer finds abhorrent.
These thoughts lead the sufferer to engage in activities to neutralize the unpleasantness of these thoughts (these activities can be mental or physical).
A group of clinical psychologists were interested in the efficacy of two different interventions for OCD offered at their clinic: cognitive behaviour therapy (CBT) and behaviour therapy (BT).
A group who were awaiting treatment acted as a control (a no treatment condition, NT). To gauge the success of therapy, the clinical psychologists measured two outcomes:
the occurrence of obsession-related behaviours (actions) and the occurrence of obsession-related cognitions (thoughts) on a single day. Service users were randomly assigned to
group 1 (CBT), group 2 (BT) or group 3 (NT). The data contains the following variables:
\itemize{
\item \strong{id}: participant ID
\item \strong{group}: the group to which service users were assigned (BT, CBT or NT)
\item \strong{thoughts}: the number of Number of obsession-related thoughts
\item \strong{actions}: the number of Number of obsession-related behaviours
}
}
\keyword{datasets}
