% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispRity.utilities.R
\name{make.dispRity}
\alias{make.dispRity}
\alias{fill.dispRity}
\alias{remove.dispRity}
\title{Make and fill \code{dispRity}.}
\usage{
make.dispRity(data, tree, call, subsets)

fill.dispRity(data, tree, check)

remove.dispRity(data, what)
}
\arguments{
\item{data}{A \code{matrix}.}

\item{tree}{Optional, a \code{phylo} or \code{multiPhylo} object.}

\item{call}{Optional, a \code{list} to be a \code{dispRity} call.}

\item{subsets}{Optional, a \code{list} to be a \code{dispRity} subsets list.}

\item{check}{Logical, whether to check the data (\code{TRUE}; default, highly advised) or not (\code{FALSE}).}

\item{what}{Which elements to remove. Can be any of the following: \code{"subsets"}, \code{"bootstraps"}, \code{"covar"}, \code{"tree"}, \code{"disparity"}. See details.}
}
\description{
Creating an empty \code{dispRity} object from a matrix
}
\details{
When using \code{remove.dispRity}, the function recursively removes any other data depending on \code{"what"}.
For example, for a data with disparity calculated for bootstrapped subsets, removing the subsets (\code{what = "subsets"}) also removes the bootstraps and the disparity data.
But removing the bootstraps (\code{what = "bootstraps"}) removes only the bootstraps draws and the disparity relating to the bootstraps (but keeps the subsets and the non-bootstrapped disparity values).
}
\examples{
## An empty dispRity object
make.dispRity()

## Still an empty dispRity object (with a matrix)
(empty <- make.dispRity(data = matrix(rnorm(12), ncol = 3)))

## A dispRity object with a matrix of 4*3
fill.dispRity(empty)

## A dispRity object with a tree
my_tree <- rtree(4, tip.label = c(1:4))
fill.dispRity(empty, tree = my_tree)

}
\author{
Thomas Guillerme
}
