% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{psi_equation_cpp}
\alias{psi_equation_cpp}
\title{(C++) Equation of the Psi Dissimilarity Score}
\usage{
psi_equation_cpp(a, b, diagonal = TRUE)
}
\arguments{
\item{a}{(required, numeric) output of \code{\link[=cost_path_sum_cpp]{cost_path_sum_cpp()}} on a least cost path.}

\item{b}{(required, numeric) auto sum of both sequences,
result of \code{\link[=auto_sum_cpp]{auto_sum_cpp()}}.}

\item{diagonal}{(optional, logical). Must be TRUE when diagonals are used in
dynamic time warping and for lock-step distances. Default: FALSE.}
}
\value{
numeric
}
\description{
Equation to compute the \code{psi} dissimilarity score
(Birks and Gordon 1985). Psi is computed as \eqn{\psi = (2a / b) - 1},
where \eqn{a} is the sum of distances between the relevant samples of two
time series, and \eqn{b} is the cumulative sum of distances between
consecutive samples in the two time series.
If \code{a} is computed with dynamic time warping, and diagonals are used in the
computation of the least cost path, then one is added to the result of the equation above.
}
\seealso{
Other Rcpp_dissimilarity_analysis: 
\code{\link{psi_dtw_cpp}()},
\code{\link{psi_ls_cpp}()},
\code{\link{psi_null_dtw_cpp}()},
\code{\link{psi_null_ls_cpp}()}
}
\concept{Rcpp_dissimilarity_analysis}
