% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distantia_matrix.R
\name{distantia_matrix}
\alias{distantia_matrix}
\title{Convert Dissimilarity Analysis Data Frame to Distance Matrix}
\usage{
distantia_matrix(df = NULL)
}
\arguments{
\item{df}{(required, data frame) Output of \code{\link[=distantia]{distantia()}}, \code{\link[=distantia_ls]{distantia_ls()}}, \code{\link[=distantia_dtw]{distantia_dtw()}}, or \code{\link[=distantia_time_delay]{distantia_time_delay()}}. Default: NULL}
}
\value{
numeric matrix
}
\description{
Transforms a data frame resulting from \code{\link[=distantia]{distantia()}} into a dissimilarity matrix.
}
\examples{
#weekly covid prevalence in three California counties
#load as tsl
#subset 5 counties
#sum by month
tsl <- tsl_initialize(
  x = covid_prevalence,
  name_column = "name",
  time_column = "time"
) |>
  tsl_subset(
    names = 1:5
  ) |>
  tsl_aggregate(
    new_time = "months",
    method = sum
  )

if(interactive()){

  #plotting first three time series
  tsl_plot(
    tsl = tsl,
    guide_columns = 3
    )

  dev.off()

}

#dissimilarity analysis
#two combinations of arguments
distantia_df <- distantia(
  tsl = tsl,
  lock_step = c(TRUE, FALSE)
)

#to dissimilarity matrix
distantia_matrix <- distantia_matrix(
  df = distantia_df
)

#returns a list of matrices
lapply(
  X = distantia_matrix,
  FUN = class
  )

#these matrices have attributes tracing how they were generated
lapply(
  X = distantia_matrix,
  FUN = \(x) attributes(x)$distantia_args
)

#plot matrix
if(interactive()){

  #plot first matrix (default behavior of utils_matrix_plot())
  utils_matrix_plot(
    m = distantia_matrix
  )

  #plot second matrix
  utils_matrix_plot(
    m = distantia_matrix[[2]]
  )

}
}
\seealso{
Other distantia_support: 
\code{\link{distantia_aggregate}()},
\code{\link{distantia_boxplot}()},
\code{\link{distantia_cluster_hclust}()},
\code{\link{distantia_cluster_kmeans}()},
\code{\link{distantia_model_frame}()},
\code{\link{distantia_spatial}()},
\code{\link{distantia_stats}()},
\code{\link{distantia_time_delay}()},
\code{\link{utils_block_size}()},
\code{\link{utils_cluster_hclust_optimizer}()},
\code{\link{utils_cluster_kmeans_optimizer}()},
\code{\link{utils_cluster_silhouette}()}
}
\concept{distantia_support}
