print.compare <- function(x, ...){
  stopifnot(is(x, "compare"), !is.null(x[["Y"]]))
  
  err_dist_fun <- if(is.null(getCall(x)[["err_dist_fun"]])){
    "'rmvnorm' (default)"
  } else {
    paste0("'", getCall(x)[["err_dist_fun"]], "'")
  }
  
  cat("'compare' object details:\n- Sample size: ", nrow(x[["Y"]]), "\n",
      "- Repetitions: ", ncol(x[["Y"]]), "\n",
      "- Error-generating function: ", err_dist_fun, "\n",
      "- 'distfreereg' objects saved: ", length(x[["dfrs"]]), "\n",
      sep = "")
}
