validate_symmetric <- function(covmat, name, sym_tol, sym_tol1){
  stopifnot(is.numeric(sym_tol), is.numeric(sym_tol1),
            sym_tol > 0, sym_tol1 > 0,
            is.list(covmat) || is.matrix(covmat) || is.numeric(covmat))
  if(!is.null(covmat)){
    if(is.matrix(covmat)) covmat <- list(covmat)#so all tests can be done with single line
    if(is.list(covmat)){
      if(!all(sapply(covmat, isSymmetric, tol = sym_tol, tol1 = sym_tol1,
                     check.attributes = FALSE)))
        stop(name, " not symmetric")
    }
  }
}
