library(distfreereg)

all.equal.distfreereg <- distfreereg:::all.equal.distfreereg
test_dfr_functions <- distfreereg:::test_dfr_functions

fcl <- function(need, covlist)
  distfreereg:::fill_covariance_list(need = need, covariance_list = covlist,
                                     matsqrt_tol = distfreereg:::default_distfreereg_tol()[["matsqrt_tol"]],
                                     solve_tol = distfreereg:::default_distfreereg_tol()[["solve_tol"]])

n <- 1e2
func <- function(X, theta) theta[1] + theta[2]*X[,1] + theta[3]*X[,2]
set.seed(20250516)
Sig_list <- lapply(seq_len(n/2), function(i) rWishart(n/2, df = 2, Sigma = diag(2))[,,i])

set.seed(20250516)
Sig <- rWishart(1, df = n, Sigma = diag(n))[,,1]
P <- fcl(need = "P", list(Sigma = Sig))[["P"]]
SqrtSigma <- fcl(need = "SqrtSigma", list(P = P))[["SqrtSigma"]]
Q <- fcl(need = "Q", list(SqrtSigma = SqrtSigma))[["Q"]]

X <- matrix(rexp(2*n, rate = 1), nrow = n)
colnames(X) <- c("a", "b")

theta <- c(2,5,1)
Y <- distfreereg:::f2ftheta(f = func, X)(theta) +
  as.vector(distfreereg:::rmvnorm(n = n, reps = 1, mean = rep(0,n), SqrtSigma = distfreereg:::matsqrt(Sig)))

set.seed(20250516)
dfr_func <- distfreereg(Y = Y, X = X, test_mean = func,
                        covariance = list(Sigma = Sig),
                        theta_init = c(1,1,1), verbose = FALSE,
                        control = list(return_on_error = FALSE),
                        stat = c("KS", "CvM", "KSmax", "KSmin"))
dfr_func
print(dfr_func, show_params = FALSE)
update(dfr_func, override = list(theta_hat = rep(1, length(dfr_func[["theta_hat"]]))))

dfr_func_mod <- dfr_func
dfr_func_mod[["p"]][["value"]] <- c(0,1,0,1)
names(dfr_func_mod[["p"]][["value"]]) <- names(dfr_func[["p"]][["value"]])
dfr_func_mod

set.seed(20250516)
dfr_func_ungrouped <- distfreereg(Y = Y, X = X, test_mean = func, group = FALSE,
                                  covariance = list(Sigma = Sig),
                                  theta_init = c(1,1,1), verbose = FALSE,
                                  control = list(return_on_error = FALSE),
                                  stat = c("KS", "CvM", "KSmax", "KSmin"))

set.seed(20250516)
dfr_func_no_X <- distfreereg(Y = Y, test_mean = function(theta) theta,
                             covariance = list(Sigma = Sig),
                             theta_init = 1, verbose = FALSE,
                             control = list(return_on_error = FALSE))

set.seed(20250516)
dfr_func_verbose <- distfreereg(Y = matrix(Y), X = rnorm(n),
                                test_mean = function(X, theta) theta*X[,1],
                                covariance = list(Sigma = Sig),
                                theta_init = 1,
                                override = list(J = dfr_func[["J"]],
                                                fitted_values = dfr_func[["fitted_values"]],
                                                mcsim_stats = dfr_func[["mcsim_stats"]]),
                                control = list(return_on_error = FALSE,
                                               theta_hat_name = "hello"),
                                stat = c("KS", "CvM", "KSmax", "KSmin"))

set.seed(20250516)
dfr_func_J_for_r <- distfreereg(Y = Y, X = X, test_mean = func,
                                covariance = list(Sigma =Sig),
                                theta_init = c(1,1,1), verbose = FALSE,
                                override = list(r = dfr_func[["mu"]]),
                                control = list(return_on_error = FALSE))

set.seed(20250516)
dfr_func_list <- distfreereg(Y = Y, X = X, test_mean = func,
                             covariance = list(Sigma = Sig_list),
                             theta_init = c(1,1,1), verbose = FALSE,
                             control = list(return_on_error = FALSE),
                             stat = c("KS", "CvM", "KSmax", "KSmin"))

set.seed(20250516)
dfr_func_vec <- distfreereg(Y = Y, X = X, test_mean = func,
                            covariance = list(Sigma = runif(n, min = 1, max = 2)),
                            theta_init = c(1,1,1), verbose = FALSE,
                            control = list(return_on_error = FALSE),
                            stat = c("KS", "CvM", "KSmax", "KSmin"))

set.seed(20250516)
dfr_func_P <- distfreereg(Y = Y, X = X, test_mean = func,
                          covariance = list(P = P),
                          theta_init = c(1,1,1), verbose = FALSE,
                          control = list(return_on_error = FALSE),
                          stat = c("KS", "CvM", "KSmax", "KSmin"))
set.seed(20250516)
dfr_func_SqrtSigma <- distfreereg(Y = Y, X = X, test_mean = func,
                                  covariance = list(SqrtSigma = SqrtSigma),
                                  theta_init = c(1,1,1), verbose = FALSE,
                                  control = list(return_on_error = FALSE),
                                  stat = c("KS", "CvM", "KSmax", "KSmin"))
set.seed(20250516)
dfr_func_Q <- distfreereg(Y = Y, X = X, test_mean = func,
                          covariance = list(Q = Q),
                          theta_init = c(1,1,1), verbose = FALSE,
                          control = list(return_on_error = FALSE),
                          stat = c("KS", "CvM", "KSmax", "KSmin"))

stopifnot(all.equal(dfr_func, dfr_func_P))
stopifnot(all.equal(dfr_func, dfr_func_SqrtSigma))
stopifnot(all.equal(dfr_func, dfr_func_Q))

newdata_function <- matrix(rexp(2*10), nrow = 10)
test_dfr_functions(dfr_func, newdata = newdata_function)

plot(dfr_func, confband_args = NULL)
plot(dfr_func, confband_args = FALSE)
plot(dfr_func, confband_args = list(m = 50,
                                    batch_len = 19,
                                    N = 1e3,
                                    conf.level = 0.9,
                                    buffer = 0.05))

plot(dfr_func, which = "residuals")
plot(dfr_func, which = "epsp")


cdfr_func <- asymptotics(dfr_func, reps = 5)
signif(rejection(cdfr_func, alpha = c(0.1, 0.5))[,2:3], digits = 3)

tryCatch(rejection(cdfr_func, alpha = c(0.1, "a")), error = function(e) warning(e))
tryCatch(rejection(cdfr_func, stat = "k"), error = function(e) warning(e))


predict(dfr_func, newdata = 1:3)



# Orderings

dfr_func_asis <- update(dfr_func, ordering = "asis", verbose = TRUE)
dfr_func_optimal <- update(dfr_func, ordering = "optimal", verbose = TRUE)
dfr_func_natural <- update(dfr_func, ordering = "natural", verbose = TRUE)
dfr_func_colname <- update(dfr_func, ordering = list("a"), verbose = TRUE)
dfr_func_res_order <- update(dfr_func,
                               override = list(res_order = dfr_func[["res_order"]],
                                               r = dfr_func[["r"]]),
                               verbose = TRUE)




### default

set.seed(20250516)
dfr_default <- distfreereg(Y = Y, X = X, test_mean = NULL,
                           covariance = list(Sigma = Sig),
                           verbose = FALSE, J = dfr_func[["J"]],
                           fitted_values = dfr_func[["fitted_values"]],
                           control = list(return_on_error = FALSE),
                           stat = c("KS", "CvM", "KSmax", "KSmin"))
dfr_default

dfr_default_verbose <- distfreereg(Y = as.matrix(Y), X = X[,1], test_mean = NULL,
                                   covariance = list(Sigma = Sig),
                                   J = rep(1, n),
                                   fitted_values = dfr_func[["fitted_values"]],
                                   control = list(return_on_error = FALSE),
                                   stat = c("KS", "CvM", "KSmax", "KSmin"))

test_dfr_functions(dfr_default, newdata = newdata_function)

stopifnot(all.equal(dfr_func, dfr_default))


# Orderings

dfr_default_asis <- update(dfr_default, ordering = "asis")
dfr_default_optimal <- update(dfr_default, ordering = "optimal")
dfr_default_natural <- update(dfr_default, ordering = "natural")
dfr_default_colname <- update(dfr_default, ordering = list("a"))





### Warnings


# Partial Outputs

dfr_func_r_error <- distfreereg(Y = Y, X = X, test_mean = func,
                                covariance = list(Sigma = Sig),
                                theta_init = c(1,1,1),
                                control = list(orth_tol = 1e-100))
names(dfr_func_r_error)




# fitted_values

set.seed(20250603)
func_fv <- function(X, theta) theta[1]*X
Sig_fv <- runif(n, min = 1, max = 3)
theta_fv <- 2
X_fv <- matrix(runif(n, min = 1, max = 5), nrow = n)
Y_fv <- theta_fv[1]*X_fv[,1] + rnorm(n, sd = sqrt(Sig_fv))
dfr_fv <- distfreereg(Y = Y_fv, X = X_fv, test_mean = func_fv,
                      covariance = list(Sigma = Sig_fv),
                      theta_init = 1, B = 1e3)






### Failures

tryCatch(distfreereg(Y = Y, X = X, test_mean = NULL, group = FALSE,
                     covariance = list(Sigma = Sig), verbose = FALSE,
                     J = dfr_func[["J"]],
                     fitted_values = dfr_func[["fitted_values"]],
                     control = list(return_on_error = FALSE),
                     stat = c("KS", "CvM", "KSmax", "KSmin"),
                     ordering = "simplex", B = 1e3, override = NULL, "a"),
         error = function(e) warning(e))

tryCatch(update(dfr_default, extra = "a"), error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = NULL, group = FALSE,
                     covariance = list(Sigma = matrix(1:10, nrow = 5)), verbose = FALSE,
                     J = dfr_func[["J"]],
                     fitted_values = dfr_func[["fitted_values"]],
                     control = list(return_on_error = FALSE)),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = NULL, group = FALSE,
                     covariance = list(Sigma = 1:10), verbose = FALSE,
                     J = dfr_func[["J"]],
                     fitted_values = dfr_func[["fitted_values"]],
                     control = list(return_on_error = FALSE)),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = NULL, group = FALSE,
                     covariance = list(Sigma = 1:10), verbose = FALSE,
                     J = dfr_func[["J"]],
                     fitted_values = NA_real_,
                     control = list(return_on_error = FALSE)),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = NULL, group = FALSE,
                     covariance = list(Sigma = 1:10), verbose = FALSE,
                     J = dfr_func[["J"]],
                     fitted_values = numeric(),
                     control = list(return_on_error = FALSE)),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = NULL, group = FALSE,
                     covariance = list(Sigma = 1:10), verbose = FALSE,
                     J = dfr_func[["J"]],
                     fitted_values = c(1, NaN),
                     control = list(return_on_error = FALSE)),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = NULL, group = FALSE,
                     covariance = list(Sigma = 1:10), verbose = FALSE,
                     J = dfr_func[["J"]],
                     fitted_values = c(1, Inf),
                     control = list(return_on_error = FALSE)),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = NULL, group = FALSE,
                     covariance = list(Sigma = 1:10), verbose = FALSE,
                     J = dfr_func[["J"]],
                     fitted_values = c(1, 2),
                     control = list(return_on_error = FALSE)),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = NULL, group = FALSE,
                     covariance = list(Sigma = 1:10), verbose = FALSE,
                     J = dfr_func[["J"]],
                     fitted_values = dfr_func[["fitted_values"]],
                     control = list(return_on_error = FALSE,
                                    solve_tol = -1)),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = function(a) a^2,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE),
                     stat = c("KS", "CvM", "KSmax", "KSmin")),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = func,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE),
                     stat = c("KS", "CvM", "KSmax", "KSmin"),
                     override = list(res_order = 1:4)),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = func,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE),
                     stat = c("KS", "CvM", "KSmax", "KSmin"),
                     override = list(r = 1:5)),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = func,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE),
                     stat = c("KS", "CvM", "KSmax", "KSmin"),
                     override = list(J = 1:5)),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = func,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE),
                     stat = c("KS", "CvM", "KSmax", "KSmin"),
                     override = list(J = 1:5, r = 1:7)),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = func,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE),
                     stat = c("KS", "CvM", "KSmax", "KSmin"),
                     override = list(fitted_values = 1:5)),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = func,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE),
                     stat = c("KS", "CvM", "KSmax", "KSmin"),
                     override = list(J = c(1,2,NA))),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = func,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE),
                     stat = c("KS", "CvM", "KSmax", "KSmin"),
                     override = list(J = 1:5)),
         error = function(e) warning(e))

tryCatch(distfreereg:::distfreereg.function(Y = Y, X = X, test_mean = b ~ a,
                                            covariance = list(Sigma = Sig),
                                            theta_init = c(1,1,1), verbose = FALSE,
                                            control = list(return_on_error = FALSE),
                                            stat = c("KS", "CvM", "KSmax", "KSmin")),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = function(x) x,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE),
                     stat = c("KS", "CvM", "KSmax", "KSmin")),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, test_mean = function(x) x,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE),
                     stat = c("KS", "CvM", "KSmax", "KSmin")),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = function(theta) theta,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE),
                     stat = c("KS", "CvM", "KSmax", "KSmin")),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X[1:5,], test_mean = function(theta) theta,
                     covariance = list(Sigma = Sig),
                     theta_init = 1, verbose = FALSE,
                     control = list(return_on_error = FALSE),
                     stat = c("KS", "CvM", "KSmax", "KSmin")),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = NULL, test_mean = function(theta) theta,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE),
                     stat = c("KS", "CvM", "KSmax", "KSmin")),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = func,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE,
                                    optimization_args = 4),
                     stat = c("KS", "CvM", "KSmax", "KSmin")),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = func,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE,
                                    optimization_fun = "hello"),
                     stat = c("KS", "CvM", "KSmax", "KSmin")),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = func,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE),
                     stat = c("KS", "CvM", "KSmax", "KSmin"),
                     ordering = c(1,2)),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = NULL,
                     covariance = list(Sigma = Sig),
                     verbose = FALSE, J = dfr_func[["J"]],
                     fitted_values = dfr_func[["fitted_values"]],
                     control = list(return_on_error = FALSE),
                     stat = c("KS", "CvM", "KSmax", "KSmin"),
                     override = list(dfr = "a")),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = NULL,
                     covariance = list(Sigma = Sig),
                     verbose = FALSE, J = dfr_func[["J"]],
                     fitted_values = dfr_func[["fitted_values"]],
                     control = list(return_on_error = FALSE),
                     stat = c("KS", "CvM", "KSmax", "KSmin"),
                     override = list(res_order = 1:4)),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = NULL,
                     covariance = list(Sigma = Sig),
                     verbose = FALSE, J = dfr_func[["J"]],
                     fitted_values = dfr_func[["fitted_values"]],
                     control = list(return_on_error = FALSE),
                     stat = c("KS", "CvM", "KSmax", "KSmin"),
                     override = list(r = 1:5)),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = NULL,
                     covariance = list(Sigma = Sig),
                     verbose = FALSE, J = dfr_func[["J"]],
                     fitted_values = dfr_func[["fitted_values"]],
                     control = list(return_on_error = FALSE),
                     stat = c("KS", "CvM", "KSmax", "KSmin"),
                     override = list(J = 1:5)),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X[1:5,], test_mean = NULL,
                     covariance = list(Sigma = Sig),
                     verbose = FALSE, J = dfr_func[["J"]],
                     fitted_values = dfr_func[["fitted_values"]],
                     control = list(return_on_error = FALSE),
                     stat = c("KS", "CvM", "KSmax", "KSmin")),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = NULL,
                     covariance = list(Sigma = Sig),
                     verbose = FALSE, J = dfr_func[["J"]],
                     fitted_values = dfr_func[["fitted_values"]],
                     control = list(return_on_error = FALSE),
                     stat = c("KS", "CvM", "KSmax", "KSmin"),
                     ordering = c(1,4)),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = NULL,
                     covariance = list(Sigma = Sig),
                     verbose = FALSE, J = dfr_func[["J"]],
                     fitted_values = dfr_func[["fitted_values"]],
                     control = list(return_on_error = FALSE),
                     stat = c("K")),
         error = function(e) warning(e))

tryCatch(plot(dfr_func, confband_args = ""), error = function(e) warning(e))
tryCatch(plot(dfr_func, density_args = ""), error = function(e) warning(e))
tryCatch(plot(dfr_func, polygon_args = ""), error = function(e) warning(e))
tryCatch(plot(dfr_func, abline_args = ""), error = function(e) warning(e))
tryCatch(plot(dfr_func, text_args = ""), error = function(e) warning(e))

tryCatch(asymptotics("dfr_default", reps = 5), error = function(e) warning(e))
tryCatch(asymptotics(dfr_default, reps = 5), error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = NULL,
                     covariance = list(Sigma = matrix(rnorm(n^2), nrow = n)),
                     verbose = FALSE, J = dfr_func[["J"]],
                     fitted_values = dfr_func[["fitted_values"]],
                     control = list(return_on_error = FALSE)),
         error = function(e) warning(e))

# P_complex_eigen <- kronecker(diag(n/2), matrix(c(cos(0.5), -sin(0.5), sin(0.5), cos(0.5)), nrow = 2))
# tryCatch(distfreereg(Y = Y, X = X, test_mean = NULL,
#                      covariance = list(P = P_complex_eigen),
#                      verbose = FALSE, J = dfr_func[["J"]],
#                      fitted_values = dfr_func[["fitted_values"]],
#                      control = list(return_on_error = FALSE)),
#          error = function(e) warning(e))

tryCatch(dfr_func <- distfreereg(Y = Y, X = X, test_mean = func,
                                 covariance = list(),
                                 theta_init = c(1,1,1), verbose = FALSE,
                                 control = list(return_on_error = FALSE)),
         error = function(e) warning(e)
)

tryCatch(dfr_func <- distfreereg(Y = Y, X = X, test_mean = func,
                                 covariance = list(Sigma = "hello"),
                                 theta_init = c(1,1,1), verbose = FALSE,
                                 control = list(return_on_error = FALSE)),
         error = function(e) warning(e)
)

tryCatch(dfr_func <- distfreereg(Y = Y, X = X, test_mean = func,
                                 covariance = list(Sigma = list("hello")),
                                 theta_init = c(1,1,1), verbose = FALSE,
                                 control = list(return_on_error = FALSE)),
         error = function(e) warning(e)
)

tryCatch(dfr_func <- distfreereg(Y = Y, X = X, test_mean = func,
                                 covariance = list(Sigma = rep(-1, n)),
                                 theta_init = c(1,1,1), verbose = FALSE,
                                 control = list(return_on_error = FALSE)),
         error = function(e) warning(e)
)

tryCatch(plot(dfr_func, confband_args = list(curve_args = 7)),
         error = function(e) warning(e))

tryCatch(plot(dfr_func, confband_args = list(polygon_args = 7)),
         error = function(e) warning(e))

tryCatch(plot(dfr_func, confband_args = list(w = "a")),
         error = function(e) warning(e))

tryCatch(confint(dfr_func, level = 1), error = function(e) warning(e))
tryCatch(confint(dfr_func, level = 0), error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = func,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     override = list(r = matrix(1:n)),
                     control = list(return_on_error = FALSE),
                     stat = c("KS", "CvM", "KSmax", "KSmin")),
         error = function(e) warning(e)
)

tryCatch(predict(dfr_func, newdata = "hello"), error = function(e) warning(e))

tryCatch(distfreereg(Y = Y[1], X = X[1,], test_mean = func,
                     covariance = list(Sigma = Sig[1,1]),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE),
                     stat = c("KS", "CvM", "KSmax", "KSmin")),
         error = function(e) warning(e)
)

tryCatch(distfreereg(Y = Y, X = X, test_mean = func,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     group = TRUE,
                     control = list(return_on_error = "hello"),
                     stat = c("KS", "CvM", "KSmax", "KSmin")),
         error = function(e) warning(e)
)

tryCatch(distfreereg(Y = Y, test_mean = function(X, theta) X * theta,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE),
                     stat = c("KS", "CvM", "KSmax", "KSmin")),
         error = function(e) warning(e)
)

tryCatch(distfreereg(Y = Y[1:5], X = X, test_mean = func,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE),
                     stat = c("KS", "CvM", "KSmax", "KSmin")),
         error = function(e) warning(e)
)

tryCatch(distfreereg(Y = Y, X = X, test_mean = func,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE,
                                    optimization_fun = optim,
                                    theta_init_arg = 1)),
         error = function(e) warning(e)
)

tryCatch(distfreereg(Y = Y, X = X, test_mean = func,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE,
                                    optimization_fun = optim,
                                    theta_init_arg = c("hello", "goodbye"))),
         error = function(e) warning(e)
)

tryCatch(distfreereg(Y = Y, X = X, test_mean = func,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE,
                                    optimization_fun = optim,
                                    theta_init_arg = "hello")),
         error = function(e) warning(e)
)

tryCatch(distfreereg(Y = Y, X = X, test_mean = func,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE,
                                    optimization_fun = optim,
                                    theta_init_arg = "par",
                                    fun_to_optimize_arg = 1)),
         error = function(e) warning(e)
)

tryCatch(distfreereg(Y = Y, X = X, test_mean = func,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE,
                                    optimization_fun = optim,
                                    theta_init_arg = "par",
                                    fun_to_optimize_arg = c("hello", "goodbye"))),
         error = function(e) warning(e)
)

tryCatch(distfreereg(Y = Y, X = X, test_mean = func,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE,
                                    optimization_fun = optim,
                                    theta_init_arg = "par",
                                    fun_to_optimize_arg = "hello")),
         error = function(e) warning(e)
)

tryCatch(distfreereg(Y = Y, X = X, test_mean = func,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE,
                                    optimization_fun = optim,
                                    theta_init_arg = "par",
                                    theta_hat_name = 1,
                                    fun_to_optimize_arg = "fn")),
         error = function(e) warning(e)
)

tryCatch(distfreereg(Y = Y, X = X, test_mean = func,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE,
                                    optimization_fun = optim,
                                    theta_init_arg = "par",
                                    theta_hat_name = c("hello", "goodbye"),
                                    fun_to_optimize_arg = "fn")),
         error = function(e) warning(e)
)

tryCatch(distfreereg(Y = Y, X = X, test_mean = func,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE,
                                    optimization_fun = optim,
                                    theta_init_arg = "par",
                                    theta_hat_name = "hello",
                                    fun_to_optimize_arg = "fn")),
         error = function(e) warning(e)
)

tryCatch(distfreereg(Y = Y, X = X, test_mean = func,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE,
                                    jacobian_args = "hello")),
         error = function(e) warning(e)
)

tryCatch(update(dfr_func, Y = 1:5, X = matrix(rnorm(10*3), nrow = 10)),
         error = function(e) warning(e)
)

tryCatch(update(dfr_func, override = list(J = dfr_func[["J"]]),
                theta_init = c(1,1)),
         error = function(e) warning(e)
)

tryCatch(distfreereg(Y = Y, X = X, test_mean = func,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1), verbose = FALSE,
                     control = "hello"),
         error = function(e) warning(e)
)

tryCatch(distfreereg(Y = Y, X = X, test_mean = NULL,
                     covariance = list(Sigma = Sig),
                     verbose = FALSE, J = dfr_func[["J"]][1:5,],
                     fitted_values = dfr_func[["fitted_values"]],
                     control = list(return_on_error = FALSE),
                     stat = c("KS", "CvM", "KSmax", "KSmin")),
         error = function(e) warning(e)
)

bad_stat <- function(x) x

tryCatch(distfreereg(Y = Y, X = X, test_mean = NULL,
                     covariance = list(Sigma = Sig),
                     verbose = FALSE, J = dfr_func[["J"]],
                     fitted_values = dfr_func[["fitted_values"]],
                     control = list(return_on_error = FALSE),
                     stat = c("bad_stat")),
         error = function(e) warning(e)
)

tryCatch(distfreereg(Y = Y, X = X, test_mean = func,
                     covariance = list(Sigma = Sig),
                     theta_init = c(1,1,1,1), verbose = FALSE,
                     control = list(return_on_error = FALSE)),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = matrix(Y), X = rep(2, n),
                     test_mean = function(X, theta) theta*X[,1],
                     covariance = list(Sigma = Sig),
                     theta_init = 1,
                     control = list(return_on_error = FALSE)),
         error = function(e) warning(e))
