# This function takes a model as input and outputs the appropriate "method" used
# to create it, in the sense of the "method" argument of distfreereg(). It is
# used by asymptotics() to extract the correct value for true_method from the
# distfreereg object.
get_method <- function(object){
  stopifnot(is(object, "distfreereg"))
  if(isTRUE(is(object[["test_mean"]], "formula") & !is.null(object[["model"]]))){
    output <- model2method(object[["model"]])
  } else {
    output <- NULL
  }
  return(output)
}
