% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streaklog.r
\name{fill}
\alias{fill}
\title{Filling of missing values in a vector, based on the marginal values of the gaps}
\usage{
fill(x, forward = TRUE, inc = 0)
}
\arguments{
\item{x}{\code{(vector)}  Vector to be filled.}

\item{forward}{\code{(logical)} Should the loop go forward or backward?}

\item{inc}{\code{(numeric)} Only if \code{x} is \code{numeric}, the function will increase the substituted value by this amount (useful for filling in sequences).}
}
\value{
A logical vector.
}
\description{
The function will loop through a vector and will substitute \code{NA} values with the value it last encountered or replaced.
}
\details{
\code{NA}s won't be substituted when they are the first values the loop encounters.
}
\examples{
# forward, replace with previous
dummy<- c(TRUE, FALSE, NA, TRUE, FALSE, NA)
fill(dummy)

# forward, replace with previous+1
dummy2 <- c(1,NA, 3, 1, 2, NA, NA, 9, NA,3)
fill(dummy2, inc=1)

# backward, replace with previous in loop direction
fill(dummy2, inc=0, forward=FALSE)
}
