% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ent_gen_simpson.R
\name{ent_gen_simpson}
\alias{ent_gen_simpson}
\alias{ent_gen_simpson.numeric}
\alias{ent_gen_simpson.species_distribution}
\title{Generalized Simpson's Entropy}
\usage{
ent_gen_simpson(x, ...)

\method{ent_gen_simpson}{numeric}(
  x,
  k = 1,
  estimator = c("Zhang", "naive"),
  as_numeric = FALSE,
  ...,
  check_arguments = TRUE
)

\method{ent_gen_simpson}{species_distribution}(
  x,
  k = 1,
  estimator = c("Zhang", "naive"),
  gamma = FALSE,
  as_numeric = FALSE,
  ...,
  check_arguments = TRUE
)
}
\arguments{
\item{x}{An object, that may be a numeric vector containing abundances or probabilities,
or an object of class \link{abundances} or \link{probabilities}.}

\item{...}{Unused.}

\item{k}{the order of Hurlbert's diversity.}

\item{estimator}{An estimator of entropy.}

\item{as_numeric}{if \code{TRUE}, a number or a numeric vector is returned rather than a tibble.}

\item{check_arguments}{if \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}

\item{gamma}{if \code{TRUE}, \eqn{\gamma} diversity, i.e. diversity of the metacommunity, is computed.}
}
\value{
A tibble with the site names, the estimators used and the estimated entropy.
}
\description{
Estimate the Generalized Simpson's entropy of species from abundance
or probability data.
}
\details{
The Generalized Simpson's Entropy \insertCite{Zhang2010}{divent} of order \eqn{k} is,
in the species accumulation curve,the probability for the individual sampled
in rank \eqn{k + 1} to belong to a new species.
It is a measure of diversity so long as \eqn{k} is lower than the number
of species \insertCite{Grabchak2016}{divent}.

Bias correction requires the number of individuals.
It is limited to orders \eqn{r} less than or equal to the number of individuals
in the community \insertCite{Zhang2014}{divent}.

Generalized Simpson's diversity cannot be estimated at a specified level
of interpolation or extrapolation, and diversity partitioning is not available.
}
\note{
The unbiased estimator is calculated by the \link[EntropyEstimation:GenSimp.z]{EntropyEstimation::GenSimp.z}
function of the \strong{EntropyEstimation} package.
}
\examples{
# Entropy of each community
ent_gen_simpson(paracou_6_abd, k = 50)
# gamma entropy
ent_gen_simpson(paracou_6_abd, k = 50, gamma = TRUE)

}
\seealso{
\link{div_gen_simpson}

#' @references
\insertAllCited{}
}
