% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accum_div_phylo.R
\name{accum_div_phylo}
\alias{accum_div_phylo}
\alias{accum_ent_phylo}
\alias{accum_ent_phylo.numeric}
\alias{accum_ent_phylo.abundances}
\alias{accum_div_phylo.numeric}
\alias{accum_div_phylo.abundances}
\title{Phylogenetic Diversity Accumulation of a Community}
\usage{
accum_ent_phylo(x, ...)

\method{accum_ent_phylo}{numeric}(
  x,
  tree,
  q = 0,
  normalize = TRUE,
  levels = NULL,
  probability_estimator = c("Chao2015", "Chao2013", "ChaoShen", "naive"),
  unveiling = c("geometric", "uniform", "none"),
  richness_estimator = c("rarefy", "jackknife", "iChao1", "Chao1", "naive"),
  jack_alpha = 0.05,
  jack_max = 10,
  coverage_estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  n_simulations = 0,
  alpha = 0.05,
  show_progress = TRUE,
  ...,
  check_arguments = TRUE
)

\method{accum_ent_phylo}{abundances}(
  x,
  tree,
  q = 0,
  normalize = TRUE,
  levels = NULL,
  probability_estimator = c("Chao2015", "Chao2013", "ChaoShen", "naive"),
  unveiling = c("geometric", "uniform", "none"),
  richness_estimator = c("rarefy", "jackknife", "iChao1", "Chao1", "naive"),
  jack_alpha = 0.05,
  jack_max = 10,
  coverage_estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  gamma = FALSE,
  n_simulations = 0,
  alpha = 0.05,
  show_progress = TRUE,
  ...,
  check_arguments = TRUE
)

accum_div_phylo(x, ...)

\method{accum_div_phylo}{numeric}(
  x,
  tree,
  q = 0,
  normalize = TRUE,
  levels = NULL,
  probability_estimator = c("Chao2015", "Chao2013", "ChaoShen", "naive"),
  unveiling = c("geometric", "uniform", "none"),
  richness_estimator = c("rarefy", "jackknife", "iChao1", "Chao1", "naive"),
  jack_alpha = 0.05,
  jack_max = 10,
  coverage_estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  n_simulations = 0,
  alpha = 0.05,
  show_progress = TRUE,
  ...,
  check_arguments = TRUE
)

\method{accum_div_phylo}{abundances}(
  x,
  tree,
  q = 0,
  normalize = TRUE,
  levels = NULL,
  probability_estimator = c("Chao2015", "Chao2013", "ChaoShen", "naive"),
  unveiling = c("geometric", "uniform", "none"),
  richness_estimator = c("rarefy", "jackknife", "iChao1", "Chao1", "naive"),
  jack_alpha = 0.05,
  jack_max = 10,
  coverage_estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  gamma = FALSE,
  n_simulations = 0,
  alpha = 0.05,
  show_progress = TRUE,
  ...,
  check_arguments = TRUE
)
}
\arguments{
\item{x}{An object, that may be a numeric vector containing abundances or probabilities,
or an object of class \link{abundances}  or \link{probabilities}.}

\item{...}{Unused.}

\item{tree}{an ultrametric, phylogenetic tree.
May be an object of class \link{phylo_divent}, \link[ape:read.tree]{ape::phylo}, \link[ade4:phylog]{ade4::phylog} or \link[stats:hclust]{stats::hclust}.}

\item{q}{a number: the order of diversity.}

\item{normalize}{if \code{TRUE}, phylogenetic is normalized: the height of the tree is set to 1.}

\item{levels}{The levels, i.e. the sample sizes of interpolation or
extrapolation: a vector of integer values.}

\item{probability_estimator}{a string containing one of the possible estimators
of the probability distribution (see \link{probabilities}).
Used only for extrapolation.}

\item{unveiling}{a string containing one of the possible unveiling methods
to estimate the probabilities of the unobserved species (see \link{probabilities}).
Used only for extrapolation.}

\item{richness_estimator}{an estimator of richness to evaluate the total number of species,
see \link{div_richness}. used for interpolation and extrapolation.}

\item{jack_alpha}{the risk level, 5\% by default, used to optimize the jackknife order.}

\item{jack_max}{the highest jackknife order allowed. Default is 10.}

\item{coverage_estimator}{an estimator of sample coverage used by \link{coverage}.}

\item{n_simulations}{the number of simulations used to estimate the confidence envelope.}

\item{alpha}{the risk level, 5\% by default.}

\item{show_progress}{if TRUE, a progress bar is shown during long computations.}

\item{check_arguments}{if \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}

\item{gamma}{if \code{TRUE}, \eqn{\gamma} diversity, i.e. diversity of the metacommunity, is computed.}
}
\value{
A tibble with the site names, the estimators used and the accumulated entropy
or diversity at each level of sampling effort.
}
\description{
Diversity and Entropy Accumulation Curves represent the accumulation of
entropy with respect to the sample size.
}
\details{
\code{accum_ent_phylo()} or \code{accum_div_phylo()} estimate the phylogenetic
diversity or entropy accumulation curve of a distribution.
See \link{ent_tsallis} for details about the computation of entropy at each level
of interpolation and extrapolation.

In accumulation curves, extrapolation if done by estimating the asymptotic
distribution of the community and estimating entropy at different levels
by interpolation.

Interpolation and extrapolation of integer orders of diversity are from
\insertCite{Chao2014;textual}{divent}.
The asymptotic richness is adjusted so that the extrapolated part of the
accumulation joins the observed value at the sample size.

"accumulation" objects can be plotted.
They generalize the classical Species Accumulation Curves (SAC) which are
diversity accumulation of order \eqn{q=0}.
}
\examples{
# Richness accumulation up to the sample size.
# 100 simulations only to save time.
autoplot(
  accum_div_phylo(mock_3sp_abd, tree = mock_3sp_tree, n_simulations = 100)
)

}
\references{
\insertAllCited{}
}
