#' @title Dominance index
#'
#' @description Modification of the Simpson's dominance index to be restricted between 0 and 1.
#'
#' @param x Vector of dimension S (spicies) with the numbers of observed individuals in each spicy. NA values are allowed. 0 values are converted to NA.
#'
#' @return Dominance index (Modified Simpson's dominance index).
#'
#' @seealso \link{simpson_D}
#'
#' @references
#' "Quantifying Diversity through Entropy Decomposition: Insights into Hominin Occupation and Carcass Processing at Qesem cave"
#'
#' @examples
#' data(Qesem_s)
#' dominance(Qesem_s$HU)
#'
#' @export
dominance <- function(x){
  x <- stats::na.omit(x)
  stopifnot(is.numeric(x))
  x <- ifelse(x==0, NA, x)
  x <- stats::na.omit(x)
  stopifnot(
    all(x >0),
    isTRUE(all.equal(x, round(x)))
  )
  S <- length(x)
  return((S*simpson_D(x)-1)/(S-1))
}
