% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R, R/predict.hdlm.R, R/predict.hdlmm.R
\name{predict}
\alias{predict}
\alias{predict.hdlm}
\alias{predict.hdlmm}
\title{predict}
\usage{
predict(
  x,
  new.data,
  new.exposure.data,
  ci.level = 0.95,
  type = "response",
  outcome = NULL,
  fixed.idx = list(),
  est.dlm = FALSE,
  verbose = TRUE,
  ...
)

\method{predict}{hdlm}(
  x,
  new.data,
  new.exposure.data,
  ci.level = 0.95,
  type = "response",
  outcome = NULL,
  fixed.idx = list(),
  est.dlm = FALSE,
  verbose = TRUE,
  ...
)

\method{predict}{hdlmm}(
  x,
  new.data,
  new.exposure.data,
  ci.level = 0.95,
  type = "response",
  outcome = NULL,
  fixed.idx = list(),
  est.dlm = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{fitted dlmtree model with class 'hdlm', 'hdlmm'}

\item{new.data}{new data frame which contains the same covariates and modifiers used to fit the model}

\item{new.exposure.data}{new data frame/list which contains the same length of exposure lags used to fit the model}

\item{ci.level}{credible interval level for posterior predictive distribution}

\item{type}{type of prediction: "response" (default) or "waic". "waic" must be specified with `outcome` parameter}

\item{outcome}{outcome required for WAIC calculation}

\item{fixed.idx}{fixed index}

\item{est.dlm}{flag for estimating dlm effect}

\item{verbose}{TRUE (default) or FALSE: print output}

\item{...}{not used}
}
\value{
list with the following elements:
\describe{
 \item{ztg}{posterior predictive mean of fixed effect}
 \item{ztg.lims}{lower/upper bound of posterior predictive distribution of fixed effect}
 \item{dlmest}{estimated exposure effect}
 \item{dlmest.lower}{lower bound of estimated exposure effect}
 \item{dlmest.upper}{upper bound of estimated exposure effect}
 \item{fhat}{posterior predictive mean of exposure effect}
 \item{fhat.lims}{lower/upper bound of posterior predictive distribution of exposure effect}
 \item{y}{posterior predictive mean}
 \item{y.lims}{lower/upper bound of posterior predictive distribution}
}
}
\description{
predict generic function for S3method
}
