% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dock_state.R
\name{get_dock}
\alias{get_dock}
\alias{get_panels}
\alias{get_panels_ids}
\alias{get_active_group}
\alias{get_grid}
\alias{get_groups}
\alias{get_groups_ids}
\alias{get_groups_panels}
\alias{get_active_views}
\alias{get_active_panel}
\alias{save_dock}
\alias{restore_dock}
\title{get dock}
\usage{
get_dock(dock)

get_panels(dock)

get_panels_ids(dock)

get_active_group(dock)

get_grid(dock)

get_groups(dock)

get_groups_ids(dock)

get_groups_panels(dock)

get_active_views(dock)

get_active_panel(dock)

save_dock(dock)

restore_dock(dock, data)
}
\arguments{
\item{dock}{Dock proxy created with \code{\link[=dock_view_proxy]{dock_view_proxy()}}.}

\item{data}{Data representing a serialised dock object.}
}
\value{
\code{get_dock} returns a list of 3 elements:
\itemize{
\item grid: a list representing the dock layout.
\item panels: a list having the same structure as \code{\link[=panel]{panel()}} composing the dock.
\item activeGroup: the current active group (a string).
}

Each other function allows to deep dive into the returned
value of \code{\link[=get_dock]{get_dock()}}.
\code{\link[=get_panels]{get_panels()}} returns the \code{panels} element of \code{\link[=get_dock]{get_dock()}}.
\code{\link[=get_panels_ids]{get_panels_ids()}} returns a character vector containing all panel ids
from \code{\link[=get_panels]{get_panels()}}.
\code{\link[=get_active_group]{get_active_group()}} extracts the \code{activeGroup} component of
\code{\link[=get_dock]{get_dock()}} as a string.
\code{\link[=get_active_views]{get_active_views()}} is a convenience function that returns the active view
in each group.
\code{\link[=get_active_panel]{get_active_panel()}} is a convenience function that returns the active panel
in the active group.
\code{\link[=get_grid]{get_grid()}} returns the \code{grid} element of \code{\link[=get_dock]{get_dock()}} which is a list.
\code{\link[=get_groups]{get_groups()}} returns a list of panel groups from \code{\link[=get_grid]{get_grid()}}.
\code{\link[=get_groups_ids]{get_groups_ids()}} returns a character vector of groups ids
from \code{\link[=get_groups]{get_groups()}}.
\code{\link[=get_groups_panels]{get_groups_panels()}} returns a list of character vector containing
the ids of each panel within each group.
\code{\link[=save_dock]{save_dock()}} and \code{\link[=restore_dock]{restore_dock()}} are used for their side effect to
allow to respectively serialise and restore a dock object.
}
\description{
get dock

get dock panels

get dock panels ids

get dock active group

get dock grid

get dock groups

get dock groups ids

get dock groups panels

get active views

get active panel

save a dock

restore a dock
}
\note{
Only works with server side functions like \link{add_panel}.
Don't call it from the UI.
}
