% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arcsineretransform.R
\name{arcsineretransform}
\alias{arcsineretransform}
\title{Re-transform the Arc sine transformed data}
\usage{
arcsineretransform(mean.vector, type)
}
\arguments{
\item{mean.vector}{vector of mean which needs to be re-transformed}

\item{type}{0 if data was in proportion prior to re-transformation, 1 if data was in percentage prior to re-transformation}
}
\value{
Arc sine re-transformed vector
}
\description{
Re-transform the arc sine transformed data. When arc sine transformation is done, the mean of the treatments needs to be re-transformed for comparison.
}
\examples{
data<-c(60,63.43495,71.56505,78.46304)
#If data was in percentage prior to re-transformation
arcsineretransform(data,1)
#If data was in proportion prior to re-transformation
arcsineretransform(data,0)
}
