% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{dkmap}
\alias{dkmap}
\title{3d topographic map}
\usage{
dkmap(
  mesh,
  y,
  alpha = 1,
  alpha.above = TRUE,
  alpha.faces = NULL,
  alpha.thresh = NULL,
  bg = "white",
  col = "slope",
  col.levels = 100,
  col.main = "black",
  col.lab = "black",
  col.sub = "black",
  col.axis = "black",
  max.range = NULL,
  min.range = NULL,
  lit = TRUE,
  cex = 2,
  cex.axis = 2,
  cex.main = 4,
  cex.sub = 3,
  cex.lab = 2,
  family = "sans",
  font.axis = 1,
  font.lab = 2,
  font.main = 3,
  font.sub = 2,
  main = "",
  sub = "",
  legend = TRUE,
  legend.lab = "y",
  legend.type = "stack",
  windowRect = NULL,
  orient = "current",
  bbox = FALSE,
  origin = TRUE,
  scalebar = FALSE,
  smooth = TRUE
)
}
\arguments{
\item{mesh}{object of class mesh3d}

\item{y}{a vector of values for each polygon of the mesh, usually a topographic variable}

\item{alpha}{an integer between 0 and 1 corresponding to alpha value for the selected polygons
(see \code{alpha.above}, \code{alpha.faces} and \code{alpha.thresh})}

\item{alpha.above}{logical, if TRUE polygons affected by \code{alpha} should have a y value above \code{alpha.thresh},
if FALSE their y value should be below \code{alpha.thresh}}

\item{alpha.faces}{a numeric vector of indices indicating which faces affected by \code{alpha}}

\item{alpha.thresh}{a numeric value indicating a threshold for alpha}

\item{bg}{the color to be used for the background. Defaults to "white".}

\item{col}{a vector of colors for texturing the polygons according to y}

\item{col.levels}{the number of color levels}

\item{col.main}{the color to be used for legend main titles. Defaults to "black".}

\item{col.lab}{the color to be used for the legend labels. Defaults to "black".}

\item{col.sub}{the color to be used for plot sub-titles. Defaults to "black".}

\item{col.axis}{the color to be used for legend axis annotation. Defaults to "black".}

\item{max.range}{optional; the maximal range of the scale}

\item{min.range}{optional; the minimal range of the scale}

\item{lit}{logical, specifying if lighting calculation should take place on geometry}

\item{cex}{a numerical value giving the amount by which plotting text and symbols should be magnified
relative to the default. This starts as 1 when a device is opened, and is reset when the layout is
changed, e.g. by setting mfrow.}

\item{cex.axis}{the magnification to be used for legend axis annotation relative to the current setting of cex.}

\item{cex.main}{the magnification to be used for main titles relative to the current setting of cex.}

\item{cex.sub}{the magnification to be used for sub-titles relative to the current setting of cex.}

\item{cex.lab}{the magnification to be used for legend labels relative to the current setting of cex.}

\item{family}{the name of a font family for drawing text. The maximum allowed length is 200
bytes.
This name gets mapped by each graphics device to a device-specific font description.
The default value is "" which means that the default device fonts will be used (and what those
are should be listed on the help page for the device).
Standard values are "serif", "sans" and "mono", and the Hershey font families are also
available.}

\item{font.axis}{the font to be used for axis annotation.}

\item{font.lab}{the font to be used for the legend axis}

\item{font.main}{the font to be used for plot main titles.}

\item{font.sub}{the font to be used for plot sub-titles.}

\item{main}{the main title (on top) using font, size (character expansion) and color par(c("font.main", "cex.main", "col.main"))}

\item{sub}{sub-title (at bottom) using font, size and color par(c("font.sub", "cex.sub", "col.sub"))}

\item{legend}{a logical indicating whether a legend should be displayed.}

\item{legend.lab}{a label for the legend axis.}

\item{legend.type}{a character string specifying the type of legend to be used; default is
"stack", which corresponds to a stacked vertical legend; "pie" generates a pie-shaped legend and "log" generates
a stacked vertical legend, but does a log transformation of the data (base: e=exp(1)). The "log" is mostly useful
for DNE maps.}

\item{windowRect}{the dimensions of the rgl window (default is the current size or, if size is below 1000*800, c(20, 20, 1020, 820))}

\item{orient}{the orientation of the view. For more details, see \code{\link{dksetview}}}

\item{bbox}{a logical, if TRUE a bounding box will be displayed around the surface object}

\item{origin}{logical, whether to set the z of the mesh's lowermost point to zero}

\item{scalebar}{A logical indicating whether a scalebar should be displayed}

\item{smooth}{A logical indicating whether the color of polygons should blend with neighbor polygons for a smoother rendering}
}
\value{
An rgl window displaying the topography of a variable over a 3d mesh.
}
\description{
Map topographic variables on a 3d triangle mesh.
}
\examples{
#Map of orientation:
orient <- orient(dkmodel$complex)
dkmap(dkmodel$complex, orient, col.levels = 8, col = "orient",
legend.lab = "Orientation (degrees)",legend.type = "pie", min.range = 0,
max.range = 360, orient = "occlusal")

#Map of area-relative curvature:
arc <- arc(dkmodel$complex)
dkmap(dkmodel$complex, arc, col = "arc", legend.lab = "ARC",
min.range = -20, max.range = 20, col.levels = 15, orient = "occlusal")

#Map of Dirichlet normal energy:
dne <- dne(dkmodel$complex)
dkmap(dkmodel$complex, dne, col = "dne", legend.lab = "DNE",
legend.type = "log", orient = "occlusal")

#Map of 3d-Area of polygons (for surface checking):
dkmap(dkmodel$complex, Rvcg::vcgArea(dkmodel$complex, perface = TRUE)$pertriangle,
legend.lab = "3d Area (mm\U00B2)", orient = "occlusal")
}
\seealso{
\code{\link[rgl]{rgl}}
}
