% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/door_test.R
\name{door_test}
\alias{door_test}
\title{Hypothesis testing for the DOOR probability}
\usage{
door_test(
  y1 = NULL,
  y2 = NULL,
  n1 = NULL,
  n2 = NULL,
  summary_obj = NULL,
  data_type = c("freq", "prop"),
  null_value = 0.5,
  alternative = c("two.sided", "less", "greater")
)
}
\arguments{
\item{y1, y2}{Numeric vectors of DOOR proportion or frequency distribution for group 1, group 2.
The entries should be ordered from most desirable to least desirable}

\item{n1, n2}{Sample sizes of group 1, group 2; must be specified if method = "prop"}

\item{summary_obj}{An object returned by \code{individual_to_summary()}; Alternative
input for y1 and y2}

\item{data_type}{Either "freq" for frequency input or "prop" for proportion input
when using y1 and y2}

\item{null_value}{A number specifying the hypothesized value of the DOOR probability}

\item{alternative}{A character describing the alternative hypothesis}
}
\value{
A \code{htest} object containing information of hypothesis test of DOOR probability
}
\description{
Hypothesis testing for the DOOR probability
}
\examples{
y1 <- c(60, 30, 10)
y2 <- c(50, 40, 10)
door_test(y1 = y1, y2 = y2)

## Hypothesis test for DOOR probability
## data:  y1 and y2
## WMW statistic = 1.2372, p-value = 0.216
## alternative hypothesis: true  is not equal to 0.5
## sample estimates:
## DOOR probability
##	           0.545
}
\seealso{
\code{\link[=door_summary]{door_summary()}}
}
