% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doremi.R
\name{generate.2order}
\alias{generate.2order}
\title{Generation of the second order differential equation solution with deSolve}
\usage{
generate.2order(
  time = 0:100,
  excitation = NULL,
  y0 = 0,
  v0 = 0,
  t0 = NULL,
  xi = 0.1,
  period = 10,
  k = 1,
  yeq = 0
)
}
\arguments{
\item{time}{is a vector containing the time values corresponding to the excitation signal.}

\item{excitation}{Is a vector containing the values of the excitation signal.}

\item{y0}{is the initial condition for the variable y(t=t0), (0, by default), it is a scalar.}

\item{v0}{is the initial condition for the derivative dy(t=t0), (0, by default), it is a scalar.}

\item{t0}{is the time corresponding to the initial condition y0 and v0. Default is the minimum value of the time vector.}

\item{xi}{is the damping factor. A negative value will produce divergence from equilibrium.}

\item{period}{is the period T of the oscillation, \eqn{T = \frac{2*\pi}{\omega_{n}}} as mentioned}

\item{k}{Default is 1. It represents the proportionality between the stationary increase of signal and the excitation increase that caused it.
Only relevant if the excitation is non null.}

\item{yeq}{is the signal equilibrium value, i.e. the stationary value reached when the excitation term is 0.}
}
\value{
Returns a data.table containing four elements:
\itemize{
  \item  t is a vector containing the corresponding time values
  \item  y is a vector containing the values calculated with deSolve so that y is a solution to a second order differential equation with constant
  coefficients (provided as input) evaluated at the time points given by t
  \item dy is a vector containing the values of the derivative calculated at the same time points
  \item exc is the excitation vector
}
}
\description{
\code{generate.2order} returns a data frame containing the time (supplied as input) and a simulated signal generated as a solution to a second order
differential equation with constant coefficients that are provided as inputs:
\deqn{\frac{d^2y}{dt} + 2\xi\omega_{n}\frac{dy}{dt} + \omega_{n}^2 y = \omega_{n}^2 k*u(t)}
Where:
y(t) is the signal, \eqn{\frac{dy}{dt}} its derivative and \eqn{\frac{d^2y}{dt}} its second derivative
\itemize{
   \item \eqn{\omega_{n} = \frac{2\pi}{T}} -where T is the period of the oscillation- is the system's natural frequency, the frequency with which the system would vibrate if there were no damping.
   The term \eqn{\omega_{n}^2} represents thus the ratio between the attraction to the equilibrium and the inertia. If we considered the example
   of a mass attached to a spring, this term would represent the ratio of the spring constant and the object's mass.
   \item \eqn{\xi} is the damping ratio. It represents the friction that damps the oscillation of the system (slows the rate of change of the variable).
   The term \eqn{2\xi\omega_n} thus represents the respective contribution of the inertia, the friction and the attraction to the equilibrium.
   The value of \eqn{\xi} determines the shape of the system time response, which can be:
   \eqn{\xi<0}	Unstable, oscillations of increasing magnitude
   \eqn{\xi=0}	Undamped, oscillating
   \eqn{0<\xi<1}	Underdamped or simply "damped": the oscillations are damped by an exponential of damping rate \eqn{\xi\omega_{n}}
   \eqn{\xi=1}	Critically damped
   \eqn{\xi>1}	Over-damped, no oscillations in the return to equilibrium
   \item k is the gain
   \item u(t) is an external excitation perturbing the dynamics
}
The excitation is also provided as input and it can be null (then the solution
will be a damped linear oscillator when the initial condition is different from 0)
}
\examples{
generate.2order(time=0:249,excitation=c(rep(0,10),rep(1,240)),period=10)
generate.2order(y0=10)
}
\keyword{differential-equation}
\keyword{second-order}
