% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TimeTreesFunctions.R
\name{write_clone_to_xml}
\alias{write_clone_to_xml}
\title{Takes an airr clone object and template and writes a BEAST2 XML file}
\usage{
write_clone_to_xml(
  clone,
  file,
  id,
  time = NULL,
  trait = NULL,
  trait_data_type = NULL,
  template = NULL,
  mcmc_length = 1e+06,
  log_every = 1000,
  replacements = NULL,
  include_germline_as_root = FALSE,
  include_germline_as_tip = FALSE,
  germline_range = c(-10000, 10000),
  tree = NULL,
  trait_list = NULL,
  log_every_trait = 10,
  tree_states = FALSE,
  start_edge_length = 100,
  start_date = NULL,
  max_start_date = NULL,
  ...
)
}
\arguments{
\item{clone}{an \code{airrClone} object}

\item{file}{output file path}

\item{id}{unique identifer for this analysis}

\item{time}{name of column representing sample time}

\item{trait}{name of column representing a trait}

\item{trait_data_type}{optional data type for the trait}

\item{template}{XML template}

\item{mcmc_length}{number of MCMC iterations}

\item{log_every}{frequency of states logged. \code{auto} will divide mcmc_length by log_target}

\item{replacements}{list of additional replacements to make in the template}

\item{include_germline_as_root}{include germline in analysis as root?}

\item{include_germline_as_tip}{include germline in analysis as tip?}

\item{germline_range}{possible date range of germline}

\item{tree}{starting tree, either a phylo object or a newick string}

\item{trait_list}{list of all possible trait values}

\item{log_every_trait}{frequency of trait states logged relative to log_every}

\item{tree_states}{use states in the starting tree?}

\item{start_edge_length}{edge length to use for all branches in starting tree}

\item{start_date}{starting date to use as prior, in forward time}

\item{max_start_date}{max starting date to use as prior, in forward time}

\item{...}{additional arguments for XML writing functions}
}
\value{
File path of the written XML file
}
\description{
Takes an airr clone object and template and writes a BEAST2 XML file
}
