% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussian_mixture_vector.R
\name{gaussian_mixture_vector}
\alias{gaussian_mixture_vector}
\title{Gaussian mixture decomposition for 1D data}
\usage{
gaussian_mixture_vector(X, Y = NULL, opts = NULL)
}
\arguments{
\item{X}{Vector of 1D data for GMM decomposition.}

\item{Y}{Vector of counts, with the same length as "X".
Applies only to binned data (Y = NULL, by default).}

\item{opts}{Parameters of run saved in \code{\link{GMM_1D_opts}} variable.}
}
\value{
Function returns a \code{list} of GMM parameters for the estimated number of components: \describe{
 \item{model}{A \code{list} of model component parameters - mean values (mu), standard deviations (sigma)
 and weights (alpha) for each component.}
 \item{IC}{The value of the selected information criterion which was used to calculate the number of components.}
 \item{logLik}{Log-likelihood statistic for the estimated number of components.}
 \item{KS}{Estimaged number of model components.}
}
}
\description{
Function to estimate number of components of a mixture normal distributions, minimizing the value of the information criterion.
}
\examples{
\donttest{
data <- generate_norm1D(1000, alpha = c(0.2,0.4,0.4), mu = c(-15,0,15), sigma = c(1,2,3))

custom.settings <- GMM_1D_opts
custom.settings$IC <- "AIC"
custom.settings$KS <- 10

exp <- gaussian_mixture_vector(data$Dist, opts = custom.settings)
}

}
\seealso{
\code{\link{runGMM}} and \code{\link{generate_norm1D}}
}
