% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2Dgenerators.R
\name{generate_dset2D}
\alias{generate_dset2D}
\title{Generator of multiple random 2D mixed-normal distributions}
\usage{
generate_dset2D(
  n = 1500,
  m = 1500,
  KS_range = 2:8,
  mu_range = c(-15, 15),
  cov_range = c(1, 5)
)
}
\arguments{
\item{n}{Number of points to generate.}

\item{m}{Number of distribution to generate.}

\item{KS_range}{Range of possible number of components of generated distribution. Default \code{KS=2:8}.}

\item{mu_range}{Range of means of components of generated distribution. Default \code{-15:15}.}

\item{cov_range}{Range of means of components of generated distribution. Default \code{1:5}.}
}
\value{
List with 2D GMM distributions where each list contains elements of \code{\link{generate_norm2D}}.
}
\description{
Generator of multiple 2D mixed normal distribution with given model parameters ranges.
}
\examples{
\donttest{
dset <- generate_dset2D(n = 1500, m = 10,
                       KS_range = 2:5,
                       mu_range = c(-10, 10),
                       cov_range = c(1, 3))
}

}
\seealso{
\code{\link{generate_norm2D}}
}
